<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\CourseUnit;
use Illuminate\Http\Request;

class CourseUnitController extends Controller
{
    public function store(Request $request, Course $course)
    {
        $data = $request->validate([
            'semester'    => ['required', 'integer', 'min:1', 'max:12'],
            'unit_code'   => ['nullable', 'string', 'max:20'],
            'unit_name'   => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:500'],
        ]);

        $data['course_id']   = $course->id;
        $data['sort_order']  = CourseUnit::where('course_id', $course->id)
                                   ->where('semester', $data['semester'])
                                   ->max('sort_order') + 1;

        CourseUnit::create($data);

        return redirect()->route('admin.courses.edit', $course)
            ->with('success', 'Unit added to Semester ' . $data['semester'] . '.');
    }

    public function destroy(Course $course, CourseUnit $unit)
    {
        $unit->delete();

        return redirect()->route('admin.courses.edit', $course)
            ->with('success', 'Unit removed.');
    }
}
