<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Certificate;
use App\Models\Course;
use App\Models\Enrollment;
use App\Models\User;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_students'     => User::where('role', 'student')->count(),
            'total_courses'      => Course::count(),
            'total_enrollments'  => Enrollment::count(),
            'total_certificates' => Certificate::count(),
        ];

        $recentEnrollments = Enrollment::with(['user', 'course'])
            ->latest()
            ->take(10)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentEnrollments'));
    }
}
