<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Enrollment;
use App\Services\CertificateService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnrollmentController extends Controller
{
    public function __construct(private CertificateService $certificateService) {}

    public function index(Request $request)
    {
        $query = Enrollment::with(['user', 'course', 'certificate'])->latest();

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        if ($request->filled('course_id')) {
            $query->where('course_id', $request->course_id);
        }

        $enrollments = $query->paginate(20);

        return view('admin.enrollments.index', compact('enrollments'));
    }

    public function complete(Enrollment $enrollment)
    {
        if ($enrollment->status === 'completed') {
            return back()->with('error', 'This enrollment is already completed.');
        }

        try {
            $this->certificateService->issue($enrollment, Auth::id());
            return back()->with('success', 'Enrollment marked complete and certificate issued.');
        } catch (\RuntimeException $e) {
            return back()->with('error', $e->getMessage());
        }
    }
}
