<?php

namespace App\Http\Controllers;

use App\Models\Certificate;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Auth;

class CertificateController extends Controller
{
    public function download($id)
    {
        $certificate = Certificate::with('enrollment.user', 'enrollment.course')
            ->findOrFail($id);

        $enrollment = $certificate->enrollment;

        /** @var \App\Models\User $user */
        $user = Auth::user();

        // Make sure only the owner can download
        if ($enrollment->user_id !== $user->id) {
            abort(403);
        }

        $pdf = Pdf::loadView('certificates.template', [
            'student'          => $enrollment->user,
            'course'           => $enrollment->course,
            'certNumber'       => $certificate->certificate_number,
            'issuedAt'         => $certificate->issued_at->format('F d, Y'),
            'verificationCode' => $certificate->verification_code,
        ])->setPaper('a4', 'landscape');

        $filename = 'certificate-' . str_replace('/', '-', $certificate->certificate_number) . '.pdf';

        return $pdf->download($filename);
    }
}
