<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Course;

class CourseController extends Controller
{
    // Show all active courses (the course listing page)
    public function index()
    {
        $courses = Course::where('is_active', true)->get();
        return view('courses.index', compact('courses'));
    }

    // Show a single course detail page
    public function show(Course $course)
    {
        $course->load('units');
        return view('courses.show', compact('course'));
    }
}
