<?php
namespace App\Http\Controllers;

use App\Models\Course;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        /** @var \App\Models\User $user */
        $user = Auth::user();

        $enrollments = $user->enrollments()
            ->with(['course', 'certificate'])
            ->latest()
            ->get();

        $certificates = $enrollments->filter(
            fn($e) => $e->status === 'completed'
        );

        $enrolledCourseIds = $enrollments->pluck('course_id');

        $courses = Course::where('is_active', true)
            ->whereNotIn('id', $enrolledCourseIds)
            ->take(3)
            ->get();

        return view('dashboard', compact('enrollments', 'certificates', 'courses'));
    }
}
