<?php

namespace App\Http\Controllers;

use App\Models\Certificate;
use Illuminate\Http\Request;

class VerificationController extends Controller
{
    public function show()
    {
        return view('verify.index');
    }

    public function check(Request $request)
    {
        $request->validate([
            'code' => ['required', 'string'],
        ]);

        return redirect()->route('verify.result', ['code' => trim($request->code)]);
    }

    public function result(string $code)
    {
        $certificate = Certificate::with('enrollment.user', 'enrollment.course')
            ->where('verification_code', $code)
            ->first();

        return view('verify.result', compact('certificate', 'code'));
    }
}
