<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Course extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'slug', 'code', 'description',
        'type', 'duration_weeks', 'fee', 'is_active'
    ];

    // A course has many enrollments
    public function enrollments()
    {
        return $this->hasMany(Enrollment::class);
    }

    // A course has many units, ordered by semester then sort_order
    public function units()
    {
        return $this->hasMany(CourseUnit::class)
                    ->orderBy('semester')
                    ->orderBy('sort_order');
    }
}
