<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Enrollment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'course_id', 'status',
        'enrolled_at', 'completed_at'
    ];

    // An enrollment belongs to a student (user)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // An enrollment belongs to a course
    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    // An enrollment may have one certificate
    public function certificate()
    {
        return $this->hasOne(Certificate::class);
    }
}
