<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('certificates', function (Blueprint $table) {
            $table->uuid('verification_code')->unique()->nullable()->after('certificate_number')
                  ->comment('UUID used for public certificate verification');
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete()
                  ->after('pdf_path')
                  ->comment('Admin user who generated this certificate');
        });
    }

    public function down(): void
    {
        Schema::table('certificates', function (Blueprint $table) {
            $table->dropForeign(['created_by']);
            $table->dropColumn(['verification_code', 'created_by']);
        });
    }
};
