<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Course;

class CourseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */

public function run(): void
{
    $courses = [
        ['title'=>'Diploma in Business Administration', 'slug'=>'business-admin',
         'code'=>'DBA',
         'type'=>'diploma', 'duration_weeks'=>156, 'fee'=>18500,
         'description'=>'Master business fundamentals and leadership.'],

        ['title'=>'Diploma in Information Technology', 'slug'=>'information-technology',
         'code'=>'DIPIT',
         'type'=>'diploma', 'duration_weeks'=>156, 'fee'=>22000,
         'description'=>'Learn computer systems and networking.'],

        ['title'=>'Artisan Certificate in Welding', 'slug'=>'welding-fabrication',
         'code'=>'AWELD',
         'type'=>'artisan', 'duration_weeks'=>26, 'fee'=>14000,
         'description'=>'Expert welding and metal fabrication skills.'],
    ];

    foreach ($courses as $course) {
        Course::updateOrCreate(
            ['slug' => $course['slug']],
            $course
        );
    }
}
}
