@extends('layouts.admin')

@section('title', 'New Course')
@section('heading', 'New Course')

@section('header-actions')
    <a href="{{ route('admin.courses.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-black/10 text-ink text-sm font-medium rounded-xl hover:bg-black/5 transition-colors">
        ← Back to Courses
    </a>
@endsection

@section('content')

<div class="mt-2 max-w-2xl">
    <form method="POST" action="{{ route('admin.courses.store') }}" class="bg-white rounded-2xl border border-black/[0.06] shadow-sm p-8 space-y-6">
        @csrf

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            {{-- Title --}}
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-ink mb-2">Course Title <span class="text-rust">*</span></label>
                <input type="text" name="title" value="{{ old('title') }}" required
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('title') border-rust @enderror">
                @error('title')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
            </div>

            {{-- Code --}}
            <div>
                <label class="block text-sm font-medium text-ink mb-2">Course Code <span class="text-rust">*</span></label>
                <input type="text" name="code" value="{{ old('code') }}" required maxlength="20"
                       placeholder="e.g. DIPIT, DBA, AWELD"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm font-mono
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('code') border-rust @enderror">
                @error('code')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-ink/40">Used in certificate numbers, e.g. CERT/2026/DIPIT/00001</p>
            </div>

            {{-- Type --}}
            <div>
                <label class="block text-sm font-medium text-ink mb-2">Course Type <span class="text-rust">*</span></label>
                <select name="type" required
                        class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                               focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                               @error('type') border-rust @enderror">
                    <option value="">Select type…</option>
                    <option value="diploma"  {{ old('type') === 'diploma'  ? 'selected' : '' }}>Diploma</option>
                    <option value="artisan"  {{ old('type') === 'artisan'  ? 'selected' : '' }}>Artisan Certificate</option>
                </select>
                @error('type')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
            </div>

            {{-- Duration --}}
            <div>
                <label class="block text-sm font-medium text-ink mb-2">Duration (weeks) <span class="text-rust">*</span></label>
                <input type="number" name="duration_weeks" value="{{ old('duration_weeks') }}" required min="1"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('duration_weeks') border-rust @enderror">
                @error('duration_weeks')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
            </div>

            {{-- Fee --}}
            <div>
                <label class="block text-sm font-medium text-ink mb-2">Fee (KES) <span class="text-rust">*</span></label>
                <input type="number" name="fee" value="{{ old('fee') }}" required min="0" step="0.01"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('fee') border-rust @enderror">
                @error('fee')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
            </div>

            {{-- Description --}}
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-ink mb-2">Description</label>
                <textarea name="description" rows="4"
                          class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                                 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all resize-none
                                 @error('description') border-rust @enderror">{{ old('description') }}</textarea>
                @error('description')
                    <p class="mt-1 text-xs text-rust">{{ $message }}</p>
                @enderror
            </div>

            {{-- Active --}}
            <div class="md:col-span-2 flex items-center gap-3">
                <input type="hidden" name="is_active" value="0">
                <input type="checkbox" name="is_active" id="is_active" value="1"
                       {{ old('is_active', '1') === '1' ? 'checked' : '' }}
                       class="w-4 h-4 accent-gold rounded">
                <label for="is_active" class="text-sm font-medium text-ink cursor-pointer">
                    Course is active and visible to students
                </label>
            </div>
        </div>

        <div class="flex items-center justify-end gap-3 pt-4 border-t border-black/[0.06]">
            <a href="{{ route('admin.courses.index') }}"
               class="px-5 py-2.5 text-sm text-ink/60 hover:text-ink transition-colors">Cancel</a>
            <button type="submit"
                    class="px-6 py-2.5 bg-gold text-ink font-semibold text-sm rounded-xl hover:bg-gold-light transition-colors shadow-sm">
                Create Course
            </button>
        </div>
    </form>
</div>

@endsection
