@extends('layouts.admin')

@section('title', 'Edit Course')
@section('heading', 'Edit Course')

@section('header-actions')
    <a href="{{ route('admin.courses.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2 bg-white border border-black/10 text-ink text-sm font-medium rounded-xl hover:bg-black/5 transition-colors">
        ← Back to Courses
    </a>
@endsection

@section('content')

@php
    $semesterCount   = $course->type === 'diploma' ? 6 : 2;
    $unitsBySemester = $course->units->groupBy('semester');
@endphp

<div class="mt-2 space-y-6 max-w-3xl">

    {{-- ── Course Details ── --}}
    <form method="POST" action="{{ route('admin.courses.update', $course) }}"
          class="bg-white rounded-2xl border border-black/[0.06] shadow-sm p-8 space-y-6">
        @csrf @method('PUT')

        <h2 class="font-semibold text-ink text-base border-b border-black/[0.06] pb-4">Course Details</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-ink mb-2">Course Title <span class="text-rust">*</span></label>
                <input type="text" name="title" value="{{ old('title', $course->title) }}" required
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('title') border-rust @enderror">
                @error('title')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-ink mb-2">Course Code <span class="text-rust">*</span></label>
                <input type="text" name="code" value="{{ old('code', $course->code) }}" required maxlength="20"
                       placeholder="e.g. DIPIT, DBA, AWELD"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm font-mono
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('code') border-rust @enderror">
                @error('code')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
                <p class="mt-1 text-xs text-ink/40">Used in certificate numbers</p>
            </div>

            <div>
                <label class="block text-sm font-medium text-ink mb-2">Course Type <span class="text-rust">*</span></label>
                <select name="type" required
                        class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                               focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                               @error('type') border-rust @enderror">
                    <option value="diploma" {{ old('type', $course->type) === 'diploma' ? 'selected' : '' }}>Diploma (3 Years · 6 Semesters)</option>
                    <option value="artisan" {{ old('type', $course->type) === 'artisan' ? 'selected' : '' }}>Artisan Certificate (6 Months · 2 Semesters)</option>
                </select>
                @error('type')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-ink mb-2">Duration (weeks) <span class="text-rust">*</span></label>
                <input type="number" name="duration_weeks" value="{{ old('duration_weeks', $course->duration_weeks) }}" required min="1"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('duration_weeks') border-rust @enderror">
                @error('duration_weeks')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-ink mb-2">Fee (KES) <span class="text-rust">*</span></label>
                <input type="number" name="fee" value="{{ old('fee', $course->fee) }}" required min="0" step="0.01"
                       class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                              focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                              @error('fee') border-rust @enderror">
                @error('fee')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-ink mb-2">Description</label>
                <textarea name="description" rows="3"
                          class="w-full px-4 py-2.5 rounded-xl border border-black/15 bg-white text-ink text-sm
                                 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all resize-none
                                 @error('description') border-rust @enderror">{{ old('description', $course->description) }}</textarea>
                @error('description')<p class="mt-1 text-xs text-rust">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2 flex items-center gap-3">
                <input type="hidden" name="is_active" value="0">
                <input type="checkbox" name="is_active" id="is_active" value="1"
                       {{ old('is_active', $course->is_active ? '1' : '0') === '1' ? 'checked' : '' }}
                       class="w-4 h-4 accent-gold rounded">
                <label for="is_active" class="text-sm font-medium text-ink cursor-pointer">Course is active and visible to students</label>
            </div>
        </div>

        <div class="flex items-center justify-end gap-3 pt-4 border-t border-black/[0.06]">
            <a href="{{ route('admin.courses.index') }}" class="px-5 py-2.5 text-sm text-ink/60 hover:text-ink transition-colors">Cancel</a>
            <button type="submit" class="px-6 py-2.5 bg-gold text-ink font-semibold text-sm rounded-xl hover:bg-gold-light transition-colors shadow-sm">
                Save Changes
            </button>
        </div>
    </form>

    {{-- ── Curriculum (Units by Semester) ── --}}
    <div class="bg-white rounded-2xl border border-black/[0.06] shadow-sm overflow-hidden">

        <div class="px-8 py-5 border-b border-black/[0.06]">
            <h2 class="font-semibold text-ink text-base">Curriculum</h2>
            <p class="text-xs text-ink/40 mt-0.5">
                {{ $semesterCount }} semesters ·
                {{ $course->units->count() }} {{ Str::plural('unit', $course->units->count()) }} added
            </p>
        </div>

        <div class="divide-y divide-black/[0.05]" id="semester-accordion">
            @for ($sem = 1; $sem <= $semesterCount; $sem++)
                @php $semUnits = $unitsBySemester->get($sem, collect()); @endphp

                <div class="semester-block">

                    {{-- Semester toggle button --}}
                    <button type="button"
                            onclick="toggleSemester({{ $sem }})"
                            class="w-full flex items-center justify-between px-8 py-4 text-left hover:bg-black/[0.015] transition-colors">
                        <div class="flex items-center gap-3">
                            <span class="w-7 h-7 rounded-lg bg-gold/10 text-gold text-xs font-bold flex items-center justify-center">{{ $sem }}</span>
                            <span class="font-medium text-sm text-ink">Semester {{ $sem }}</span>
                            @if($semUnits->count())
                                <span class="text-xs text-ink/35">— {{ $semUnits->count() }} {{ Str::plural('unit', $semUnits->count()) }}</span>
                            @else
                                <span class="text-xs text-ink/25 italic">— no units yet</span>
                            @endif
                        </div>
                        <span id="arrow-{{ $sem }}" class="text-xs text-ink/30 transition-transform">▼</span>
                    </button>

                    {{-- Semester body --}}
                    <div id="sem-body-{{ $sem }}" class="{{ $sem === 1 ? '' : 'hidden' }} px-8 pb-6">

                        {{-- Existing units list --}}
                        @if($semUnits->count())
                            <div class="mb-4 space-y-2">
                                @foreach($semUnits as $unit)
                                    <div class="flex items-center justify-between py-2.5 px-4 rounded-xl bg-black/[0.025] border border-black/[0.05]">
                                        <div class="flex items-center gap-3 min-w-0">
                                            @if($unit->unit_code)
                                                <span class="font-mono text-xs bg-ink/5 text-ink/50 px-2 py-0.5 rounded shrink-0">{{ $unit->unit_code }}</span>
                                            @endif
                                            <div class="min-w-0">
                                                <div class="text-sm font-medium text-ink truncate">{{ $unit->unit_name }}</div>
                                                @if($unit->description)
                                                    <div class="text-xs text-ink/40 truncate mt-0.5">{{ $unit->description }}</div>
                                                @endif
                                            </div>
                                        </div>
                                        <form method="POST"
                                              action="{{ route('admin.courses.units.destroy', [$course, $unit]) }}"
                                              onsubmit="return confirm('Remove this unit?')">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="ml-4 text-xs text-rust/60 hover:text-rust transition-colors shrink-0">
                                                Remove
                                            </button>
                                        </form>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-xs text-ink/30 italic mb-4">No units added to this semester yet.</p>
                        @endif

                        {{-- Add unit form --}}
                        <form method="POST" action="{{ route('admin.courses.units.store', $course) }}"
                              class="bg-black/[0.02] border border-dashed border-black/10 rounded-xl p-4">
                            @csrf
                            <input type="hidden" name="semester" value="{{ $sem }}">
                            <p class="text-xs font-semibold text-ink/40 uppercase tracking-wide mb-3">Add Unit to Semester {{ $sem }}</p>

                            <div class="grid grid-cols-1 md:grid-cols-[110px_1fr] gap-3 mb-3">
                                <div>
                                    <label class="block text-xs text-ink/50 mb-1">Unit Code</label>
                                    <input type="text" name="unit_code" maxlength="20" placeholder="BUS101"
                                           class="w-full px-3 py-2 rounded-lg border border-black/10 bg-white text-ink text-sm font-mono
                                                  focus:outline-none focus:border-gold focus:ring-1 focus:ring-gold/20 transition-all">
                                </div>
                                <div>
                                    <label class="block text-xs text-ink/50 mb-1">Unit Name <span class="text-rust">*</span></label>
                                    <input type="text" name="unit_name" required placeholder="e.g. Introduction to Management"
                                           class="w-full px-3 py-2 rounded-lg border border-black/10 bg-white text-ink text-sm
                                                  focus:outline-none focus:border-gold focus:ring-1 focus:ring-gold/20 transition-all">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="block text-xs text-ink/50 mb-1">Description <span class="text-ink/30">(optional)</span></label>
                                <input type="text" name="description" maxlength="500" placeholder="Brief description of what this unit covers"
                                       class="w-full px-3 py-2 rounded-lg border border-black/10 bg-white text-ink text-sm
                                              focus:outline-none focus:border-gold focus:ring-1 focus:ring-gold/20 transition-all">
                            </div>

                            <button type="submit"
                                    class="inline-flex items-center gap-1.5 px-4 py-2 bg-ink text-white text-xs font-semibold rounded-lg hover:bg-ink/80 transition-colors">
                                + Add Unit
                            </button>
                        </form>
                    </div>

                </div>
            @endfor
        </div>
    </div>

</div>

@push('scripts')
<script>
function toggleSemester(sem) {
    const body  = document.getElementById('sem-body-' + sem);
    const arrow = document.getElementById('arrow-' + sem);
    const hidden = body.classList.toggle('hidden');
    arrow.textContent = hidden ? '▼' : '▲';
}
</script>
@endpush

@endsection
