@extends('layouts.admin')

@section('title', 'Courses')
@section('heading', 'Courses')

@section('header-actions')
    <a href="{{ route('admin.courses.create') }}"
       class="inline-flex items-center gap-2 px-4 py-2 bg-gold text-ink font-semibold text-sm rounded-xl hover:bg-gold-light transition-colors shadow-sm">
        + New Course
    </a>
@endsection

@section('content')

<div class="mt-2 bg-white rounded-2xl border border-black/[0.06] shadow-sm overflow-hidden">

    @if ($courses->isEmpty())
        <div class="py-20 text-center">
            <div class="text-4xl mb-4">◈</div>
            <p class="text-ink/50 text-sm mb-4">No courses yet.</p>
            <a href="{{ route('admin.courses.create') }}" class="text-gold text-sm font-medium hover:underline">Create your first course →</a>
        </div>
    @else
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="border-b border-black/[0.06] text-left">
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Course</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Code</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Type</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Duration</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Fee</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Enrolled</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Status</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-black/[0.04]">
                    @foreach ($courses as $course)
                        <tr class="hover:bg-black/[0.015] transition-colors">
                            <td class="px-6 py-4">
                                <div class="font-semibold text-ink">{{ $course->title }}</div>
                                <div class="text-xs text-ink/40 mt-0.5">{{ Str::limit($course->description, 60) }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @if ($course->code)
                                    <span class="font-mono text-xs bg-ink/5 text-ink/70 px-2 py-1 rounded">{{ $course->code }}</span>
                                @else
                                    <span class="text-ink/30 italic text-xs">—</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium
                                    {{ $course->type === 'diploma' ? 'bg-sage/10 text-sage border border-sage/20' : 'bg-rust/10 text-rust border border-rust/20' }}">
                                    {{ ucfirst($course->type) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-ink/60">{{ $course->duration_weeks }}w</td>
                            <td class="px-6 py-4 text-ink/70 font-medium">KES {{ number_format($course->fee) }}</td>
                            <td class="px-6 py-4 text-ink/60">{{ $course->enrollments_count }}</td>
                            <td class="px-6 py-4">
                                @if ($course->is_active)
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-sage/10 text-sage border border-sage/20">
                                        ● Active
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-black/5 text-ink/40 border border-black/10">
                                        ● Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.courses.edit', $course) }}"
                                       class="text-xs text-gold hover:text-gold-light font-medium transition-colors">Edit</a>
                                    <form method="POST" action="{{ route('admin.courses.destroy', $course) }}"
                                          onsubmit="return confirm('Delete this course? This cannot be undone.')">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="text-xs text-rust hover:text-rust/70 font-medium transition-colors">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>

@endsection
