@extends('layouts.admin')

@section('title', 'Admin Dashboard')
@section('heading', 'Dashboard')

@section('content')

{{-- Stats row --}}
<div class="grid grid-cols-2 lg:grid-cols-4 gap-5 mt-2">
    @php
        $statCards = [
            ['label' => 'Total Students',     'value' => $stats['total_students'],     'icon' => '◉', 'color' => 'text-gold'],
            ['label' => 'Active Courses',      'value' => $stats['total_courses'],      'icon' => '◈', 'color' => 'text-sage'],
            ['label' => 'Enrollments',         'value' => $stats['total_enrollments'],  'icon' => '◎', 'color' => 'text-rust'],
            ['label' => 'Certificates Issued', 'value' => $stats['total_certificates'], 'icon' => '◆', 'color' => 'text-gold-light'],
        ];
    @endphp
    @foreach ($statCards as $card)
        <div class="bg-white rounded-2xl border border-black/[0.06] p-5 shadow-sm">
            <div class="flex items-start justify-between mb-3">
                <span class="text-2xl {{ $card['color'] }}">{{ $card['icon'] }}</span>
            </div>
            <div class="text-3xl font-bold text-ink font-serif">{{ number_format($card['value']) }}</div>
            <div class="text-xs text-ink/50 mt-1">{{ $card['label'] }}</div>
        </div>
    @endforeach
</div>

{{-- Recent Enrollments --}}
<div class="mt-8 bg-white rounded-2xl border border-black/[0.06] shadow-sm overflow-hidden">
    <div class="px-6 py-5 border-b border-black/[0.06] flex items-center justify-between">
        <h2 class="font-semibold text-ink text-base">Recent Enrollments</h2>
        <a href="{{ route('admin.enrollments.index') }}" class="text-xs text-gold hover:text-gold-light font-medium transition-colors">View all →</a>
    </div>

    @if ($recentEnrollments->isEmpty())
        <div class="px-6 py-12 text-center text-ink/40 text-sm">No enrollments yet.</div>
    @else
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="border-b border-black/[0.06] text-left">
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Student</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Course</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Enrolled</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-black/[0.04]">
                    @foreach ($recentEnrollments as $enrollment)
                        <tr class="hover:bg-black/[0.015] transition-colors">
                            <td class="px-6 py-4">
                                <div class="font-medium text-ink">{{ $enrollment->user->name }}</div>
                                <div class="text-xs text-ink/40">{{ $enrollment->user->email }}</div>
                            </td>
                            <td class="px-6 py-4 text-ink/70">{{ $enrollment->course->title }}</td>
                            <td class="px-6 py-4 text-ink/50 text-xs">{{ $enrollment->created_at->format('d M Y') }}</td>
                            <td class="px-6 py-4">
                                @if ($enrollment->status === 'completed')
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-sage/10 text-sage border border-sage/20">
                                        ✓ Completed
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-gold/10 text-gold border border-gold/20">
                                        ◷ Active
                                    </span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>

{{-- Quick links --}}
<div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
    <a href="{{ route('admin.courses.create') }}"
       class="flex items-center gap-4 bg-white rounded-2xl border border-black/[0.06] p-5 shadow-sm hover:border-gold/40 hover:shadow-md transition-all group">
        <div class="w-10 h-10 rounded-xl bg-gold/10 flex items-center justify-center text-gold text-lg group-hover:bg-gold group-hover:text-ink transition-all">+</div>
        <div>
            <div class="font-semibold text-ink text-sm">Add New Course</div>
            <div class="text-xs text-ink/40 mt-0.5">Create a new programme</div>
        </div>
    </a>
    <a href="{{ route('admin.enrollments.index') }}"
       class="flex items-center gap-4 bg-white rounded-2xl border border-black/[0.06] p-5 shadow-sm hover:border-gold/40 hover:shadow-md transition-all group">
        <div class="w-10 h-10 rounded-xl bg-sage/10 flex items-center justify-center text-sage text-lg group-hover:bg-sage group-hover:text-white transition-all">◎</div>
        <div>
            <div class="font-semibold text-ink text-sm">Manage Enrollments</div>
            <div class="text-xs text-ink/40 mt-0.5">Issue certificates</div>
        </div>
    </a>
    <a href="{{ route('admin.courses.index') }}"
       class="flex items-center gap-4 bg-white rounded-2xl border border-black/[0.06] p-5 shadow-sm hover:border-gold/40 hover:shadow-md transition-all group">
        <div class="w-10 h-10 rounded-xl bg-rust/10 flex items-center justify-center text-rust text-lg group-hover:bg-rust group-hover:text-white transition-all">◈</div>
        <div>
            <div class="font-semibold text-ink text-sm">All Courses</div>
            <div class="text-xs text-ink/40 mt-0.5">View and manage courses</div>
        </div>
    </a>
</div>

@endsection
