@extends('layouts.admin')

@section('title', 'Enrollments')
@section('heading', 'Enrollments')

@section('content')

{{-- Filters --}}
<form method="GET" action="{{ route('admin.enrollments.index') }}" class="mt-2 mb-5 flex flex-wrap gap-3">
    <select name="status" onchange="this.form.submit()"
            class="px-4 py-2 rounded-xl border border-black/15 bg-white text-ink text-sm
                   focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20">
        <option value="">All Statuses</option>
        <option value="active"    {{ request('status') === 'active'    ? 'selected' : '' }}>Active</option>
        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
    </select>
    @if (request()->hasAny(['status', 'course_id']))
        <a href="{{ route('admin.enrollments.index') }}"
           class="px-4 py-2 rounded-xl border border-black/10 bg-white text-ink/50 text-sm hover:text-ink transition-colors">
            Clear filters
        </a>
    @endif
</form>

<div class="bg-white rounded-2xl border border-black/[0.06] shadow-sm overflow-hidden">
    @if ($enrollments->isEmpty())
        <div class="py-20 text-center text-ink/40 text-sm">No enrollments found.</div>
    @else
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="border-b border-black/[0.06] text-left">
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Student</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Course</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Enrolled</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Status</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Certificate</th>
                        <th class="px-6 py-3 font-medium text-ink/50 text-xs uppercase tracking-wide">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-black/[0.04]">
                    @foreach ($enrollments as $enrollment)
                        <tr class="hover:bg-black/[0.015] transition-colors">
                            <td class="px-6 py-4">
                                <div class="font-medium text-ink">{{ $enrollment->user->name }}</div>
                                <div class="text-xs text-ink/40">{{ $enrollment->user->email }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-ink/80">{{ $enrollment->course->title }}</div>
                                @if ($enrollment->course->code)
                                    <span class="font-mono text-[10px] text-ink/40">{{ $enrollment->course->code }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-ink/50 text-xs">{{ $enrollment->created_at->format('d M Y') }}</td>
                            <td class="px-6 py-4">
                                @if ($enrollment->status === 'completed')
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-sage/10 text-sage border border-sage/20">
                                        ✓ Completed
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-full text-xs font-medium bg-gold/10 text-gold border border-gold/20">
                                        ◷ Active
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if ($enrollment->certificate)
                                    <div class="text-xs">
                                        <div class="font-mono text-ink/60">{{ $enrollment->certificate->certificate_number }}</div>
                                        <div class="text-ink/30 mt-0.5">{{ $enrollment->certificate->issued_at->format('d M Y') }}</div>
                                    </div>
                                @else
                                    <span class="text-ink/30 text-xs italic">Not issued</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if ($enrollment->status !== 'completed')
                                    <form method="POST"
                                          action="{{ route('admin.enrollments.complete', $enrollment) }}"
                                          onsubmit="return confirm('Mark complete and issue a certificate for {{ addslashes($enrollment->user->name) }}?')">
                                        @csrf
                                        <button type="submit"
                                                class="inline-flex items-center gap-1.5 px-3 py-1.5 bg-gold text-ink text-xs font-semibold rounded-lg hover:bg-gold-light transition-colors shadow-sm">
                                            ✓ Issue Certificate
                                        </button>
                                    </form>
                                @else
                                    <span class="text-ink/30 text-xs">—</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if ($enrollments->hasPages())
            <div class="px-6 py-4 border-t border-black/[0.06]">
                {{ $enrollments->links() }}
            </div>
        @endif
    @endif
</div>

@endsection
