<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign In — AcademiaCraft</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-cream min-h-screen flex">

    {{-- LEFT PANEL — Branding --}}
    <div class="hidden lg:flex w-[45%] bg-ink flex-col justify-between p-14 relative overflow-hidden">

        {{-- Top colour strip --}}
        <div class="absolute top-0 left-0 right-0 h-[4px] bg-gradient-to-r from-gold via-rust to-sage"></div>

        {{-- Decorative circles --}}
        <div class="absolute right-[-80px] top-[-80px] w-[350px] h-[350px] rounded-full border border-white/[0.05] pointer-events-none"></div>
        <div class="absolute right-[40px] top-[60px] w-[180px] h-[180px] rounded-full border border-gold/[0.1] pointer-events-none"></div>
        <div class="absolute left-[-60px] bottom-[-60px] w-[280px] h-[280px] rounded-full border border-white/[0.04] pointer-events-none"></div>

        {{-- Logo --}}
        <a href="/" class="flex items-center gap-3 relative z-10">
            <div class="w-10 h-10 bg-gold rounded-lg flex items-center justify-center font-serif font-black text-sm text-ink">AC</div>
            <span class="font-serif font-bold text-lg text-white">Academia<span class="text-gold">Craft</span></span>
        </a>

        {{-- Middle content --}}
        <div class="relative z-10">
            <div class="text-[0.65rem] font-bold uppercase tracking-[0.15em] text-gold flex items-center gap-2 mb-4">
                <span class="w-5 h-px bg-gold inline-block"></span> Welcome Back
            </div>
            <h2 class="font-serif text-4xl font-black text-white leading-tight tracking-tight mb-4">
                Continue Your<br><em class="text-gold italic">Learning Journey</em>
            </h2>
            <p class="text-white/40 text-sm leading-relaxed max-w-xs">
                Sign in to access your courses, track your progress, and download your certificates.
            </p>

            {{-- Stats --}}
            <div class="flex gap-8 mt-10">
                <div>
                    <div class="font-serif text-2xl font-black text-white">2,400+</div>
                    <div class="text-[0.65rem] uppercase tracking-widest text-white/25 font-medium mt-0.5">Graduates</div>
                </div>
                <div class="w-px bg-white/10"></div>
                <div>
                    <div class="font-serif text-2xl font-black text-white">97%</div>
                    <div class="text-[0.65rem] uppercase tracking-widest text-white/25 font-medium mt-0.5">Pass Rate</div>
                </div>
                <div class="w-px bg-white/10"></div>
                <div>
                    <div class="font-serif text-2xl font-black text-white">18</div>
                    <div class="text-[0.65rem] uppercase tracking-widest text-white/25 font-medium mt-0.5">Programmes</div>
                </div>
            </div>

            {{-- Testimonial --}}
            <div class="mt-10 bg-white/[0.05] border border-white/[0.08] rounded-2xl p-5">
                <div class="text-gold text-xs tracking-widest mb-3">★★★★★</div>
                <p class="text-white/55 text-sm leading-relaxed italic mb-4">
                    "AcademiaCraft changed my career. The certificate I earned opened doors I never thought possible."
                </p>
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-gold to-rust flex items-center justify-center font-serif font-bold text-xs text-ink">JM</div>
                    <div>
                        <div class="text-xs font-semibold text-white">James Mwangi</div>
                        <div class="text-[0.65rem] text-white/30">Diploma in IT Graduate</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Bottom --}}
        <div class="relative z-10 text-[0.65rem] text-white/20">
            © {{ date('Y') }} AcademiaCraft Institute. All rights reserved.
        </div>
    </div>

    {{-- RIGHT PANEL — Form --}}
    <div class="flex-1 flex items-center justify-center p-8 lg:p-16">
        <div class="w-full max-w-md">

            {{-- Mobile logo --}}
            <a href="/" class="flex items-center gap-3 mb-10 lg:hidden">
                <div class="w-9 h-9 bg-ink rounded-lg flex items-center justify-center font-serif font-black text-sm text-gold">AC</div>
                <span class="font-serif font-bold text-lg text-ink">Academia<span class="text-gold">Craft</span></span>
            </a>

            <div class="mb-8">
                <h1 class="font-serif text-3xl font-black text-ink tracking-tight mb-1.5">Sign In</h1>
                <p class="text-sm text-ink/45">Don't have an account? <a href="{{ route('register') }}" class="text-gold font-semibold hover:underline">Register free →</a></p>
            </div>

            {{-- Session status --}}
            @if(session('status'))
                <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-xl text-sm font-medium mb-6">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('login') }}" class="space-y-5">
                @csrf

                {{-- Email --}}
                <div>
                    <label for="email" class="block text-xs font-bold uppercase tracking-widest text-ink/50 mb-2">Email Address</label>
                    <input id="email" type="email" name="email" value="{{ old('email') }}"
                           required autofocus autocomplete="username"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('email') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="you@example.com">
                    @error('email')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Password --}}
                <div>
                    <div class="flex justify-between items-center mb-2">
                        <label for="password" class="block text-xs font-bold uppercase tracking-widest text-ink/50">Password</label>
                        @if(Route::has('password.request'))
                            <a href="{{ route('password.request') }}" class="text-xs text-gold hover:underline font-medium">Forgot password?</a>
                        @endif
                    </div>
                    <input id="password" type="password" name="password"
                           required autocomplete="current-password"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('password') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="••••••••">
                    @error('password')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Remember me --}}
                <div class="flex items-center gap-2.5">
                    <input id="remember_me" type="checkbox" name="remember"
                           class="w-4 h-4 rounded border-ink/20 text-gold focus:ring-gold/30 cursor-pointer">
                    <label for="remember_me" class="text-sm text-ink/55 cursor-pointer select-none">Keep me signed in</label>
                </div>

                {{-- Submit --}}
                <button type="submit"
                        class="w-full bg-ink text-cream font-bold py-4 rounded-xl hover:bg-gold hover:text-ink transition-all duration-200 text-sm tracking-wide mt-2">
                    Sign In to Dashboard →
                </button>
            </form>

            {{-- Divider --}}
            <div class="flex items-center gap-4 my-7">
                <div class="flex-1 h-px bg-ink/10"></div>
                <span class="text-xs text-ink/30 font-medium">or</span>
                <div class="flex-1 h-px bg-ink/10"></div>
            </div>

            <a href="{{ route('register') }}"
               class="block w-full text-center border-2 border-ink/15 text-ink font-semibold py-3.5 rounded-xl hover:border-ink hover:bg-ink hover:text-cream transition-all duration-200 text-sm">
                Create a New Account
            </a>

            <div class="mt-8 text-center">
                <a href="/" class="text-xs text-ink/30 hover:text-ink/60 transition-colors">← Back to homepage</a>
            </div>
        </div>
    </div>

</body>
</html>
