<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Account — AcademiaCraft</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-cream min-h-screen flex">

    {{-- LEFT PANEL — Branding --}}
    <div class="hidden lg:flex w-[45%] bg-ink flex-col justify-between p-14 relative overflow-hidden">

        {{-- Top colour strip --}}
        <div class="absolute top-0 left-0 right-0 h-[4px] bg-gradient-to-r from-gold via-rust to-sage"></div>

        {{-- Decorative circles --}}
        <div class="absolute right-[-80px] top-[-80px] w-[350px] h-[350px] rounded-full border border-white/[0.05] pointer-events-none"></div>
        <div class="absolute right-[40px] top-[60px] w-[180px] h-[180px] rounded-full border border-gold/[0.1] pointer-events-none"></div>
        <div class="absolute left-[-60px] bottom-[-60px] w-[280px] h-[280px] rounded-full border border-white/[0.04] pointer-events-none"></div>

        {{-- Logo --}}
        <a href="/" class="flex items-center gap-3 relative z-10">
            <div class="w-10 h-10 bg-gold rounded-lg flex items-center justify-center font-serif font-black text-sm text-ink">AC</div>
            <span class="font-serif font-bold text-lg text-white">Academia<span class="text-gold">Craft</span></span>
        </a>

        {{-- Middle content --}}
        <div class="relative z-10">
            <div class="text-[0.65rem] font-bold uppercase tracking-[0.15em] text-gold flex items-center gap-2 mb-4">
                <span class="w-5 h-px bg-gold inline-block"></span> Get Started Free
            </div>
            <h2 class="font-serif text-4xl font-black text-white leading-tight tracking-tight mb-4">
                Your Career Starts<br><em class="text-gold italic">Here & Now</em>
            </h2>
            <p class="text-white/40 text-sm leading-relaxed max-w-xs">
                Join over 2,400 graduates who have earned nationally recognized certificates and transformed their careers.
            </p>

            {{-- Steps preview --}}
            <div class="mt-10 space-y-5">
                <div class="flex items-center gap-4">
                    <div class="w-9 h-9 rounded-full border border-gold/30 flex items-center justify-center font-serif font-bold text-xs text-gold shrink-0">01</div>
                    <div>
                        <div class="text-sm font-semibold text-white">Create your account</div>
                        <div class="text-[0.7rem] text-white/30 mt-0.5">Takes less than 2 minutes</div>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="w-9 h-9 rounded-full border border-gold/30 flex items-center justify-center font-serif font-bold text-xs text-gold shrink-0">02</div>
                    <div>
                        <div class="text-sm font-semibold text-white">Choose your course</div>
                        <div class="text-[0.7rem] text-white/30 mt-0.5">Diploma or Artisan programmes</div>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="w-9 h-9 rounded-full border border-gold/30 flex items-center justify-center font-serif font-bold text-xs text-gold shrink-0">03</div>
                    <div>
                        <div class="text-sm font-semibold text-white">Earn your certificate</div>
                        <div class="text-[0.7rem] text-white/30 mt-0.5">Nationally recognized & downloadable</div>
                    </div>
                </div>
            </div>

            {{-- Certificate badge --}}
            <div class="mt-10 bg-white/[0.05] border border-white/[0.08] rounded-2xl p-5 flex items-center gap-4">
                <div class="w-12 h-12 rounded-xl bg-gold/10 border border-gold/20 flex items-center justify-center text-2xl shrink-0">🏅</div>
                <div>
                    <div class="text-xs font-bold uppercase tracking-widest text-gold mb-0.5">On Completion</div>
                    <div class="text-sm font-semibold text-white">Receive your digital certificate instantly</div>
                    <div class="text-[0.7rem] text-white/30 mt-0.5">Downloadable · Shareable · Verified</div>
                </div>
            </div>
        </div>

        {{-- Bottom --}}
        <div class="relative z-10 text-[0.65rem] text-white/20">
            © {{ date('Y') }} AcademiaCraft Institute. All rights reserved.
        </div>
    </div>

    {{-- RIGHT PANEL — Form --}}
    <div class="flex-1 flex items-center justify-center p-8 lg:p-16 overflow-y-auto">
        <div class="w-full max-w-md py-8">

            {{-- Mobile logo --}}
            <a href="/" class="flex items-center gap-3 mb-10 lg:hidden">
                <div class="w-9 h-9 bg-ink rounded-lg flex items-center justify-center font-serif font-black text-sm text-gold">AC</div>
                <span class="font-serif font-bold text-lg text-ink">Academia<span class="text-gold">Craft</span></span>
            </a>

            <div class="mb-8">
                <h1 class="font-serif text-3xl font-black text-ink tracking-tight mb-1.5">Create Account</h1>
                <p class="text-sm text-ink/45">Already registered? <a href="{{ route('login') }}" class="text-gold font-semibold hover:underline">Sign in →</a></p>
            </div>

            <form method="POST" action="{{ route('register') }}" class="space-y-5">
                @csrf

                {{-- Full name --}}
                <div>
                    <label for="name" class="block text-xs font-bold uppercase tracking-widest text-ink/50 mb-2">Full Name</label>
                    <input id="name" type="text" name="name" value="{{ old('name') }}"
                           required autofocus autocomplete="name"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('name') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="e.g. Amina Wanjiku">
                    @error('name')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Email --}}
                <div>
                    <label for="email" class="block text-xs font-bold uppercase tracking-widest text-ink/50 mb-2">Email Address</label>
                    <input id="email" type="email" name="email" value="{{ old('email') }}"
                           required autocomplete="username"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('email') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="you@example.com">
                    @error('email')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Password --}}
                <div>
                    <label for="password" class="block text-xs font-bold uppercase tracking-widest text-ink/50 mb-2">Password</label>
                    <input id="password" type="password" name="password"
                           required autocomplete="new-password"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('password') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="Minimum 8 characters">
                    @error('password')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Confirm password --}}
                <div>
                    <label for="password_confirmation" class="block text-xs font-bold uppercase tracking-widest text-ink/50 mb-2">Confirm Password</label>
                    <input id="password_confirmation" type="password" name="password_confirmation"
                           required autocomplete="new-password"
                           class="w-full bg-white border border-ink/[0.12] rounded-xl px-4 py-3.5 text-sm text-ink placeholder-ink/25 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all duration-200 @error('password_confirmation') border-rust ring-2 ring-rust/20 @enderror"
                           placeholder="Re-enter your password">
                    @error('password_confirmation')
                        <p class="text-rust text-xs mt-1.5 font-medium">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Submit --}}
                <button type="submit"
                        class="w-full bg-gold text-ink font-bold py-4 rounded-xl hover:bg-gold-light transition-all duration-200 text-sm tracking-wide mt-2">
                    Create My Account →
                </button>

                <p class="text-center text-[0.7rem] text-ink/30 leading-relaxed">
                    By registering you agree to our terms of use and privacy policy.
                </p>
            </form>

            {{-- Divider --}}
            <div class="flex items-center gap-4 my-7">
                <div class="flex-1 h-px bg-ink/10"></div>
                <span class="text-xs text-ink/30 font-medium">already a student?</span>
                <div class="flex-1 h-px bg-ink/10"></div>
            </div>

            <a href="{{ route('login') }}"
               class="block w-full text-center border-2 border-ink/15 text-ink font-semibold py-3.5 rounded-xl hover:border-ink hover:bg-ink hover:text-cream transition-all duration-200 text-sm">
                Sign In to My Account
            </a>

            <div class="mt-8 text-center">
                <a href="/" class="text-xs text-ink/30 hover:text-ink/60 transition-colors">← Back to homepage</a>
            </div>
        </div>
    </div>

</body>
</html>
