<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
    * { margin: 0; padding: 0; }

    body {
        font-family: Georgia, 'Times New Roman', serif;
        background: #0D0D0D;
        color: #FFFFFF;
        margin: 0;
        padding: 0;
        width: 297mm;
        height: 210mm;
    }

    /* ── Decorative borders ──
       Absolute positioned, explicit top/left/width/height (dompdf-safe, no inset shorthand)
    */
    .border-outer {
        position: absolute;
        top: 10mm; left: 10mm;
        width: 277mm; height: 190mm;
        border: 1px solid #4a3808;
    }
    .border-inner {
        position: absolute;
        top: 14mm; left: 14mm;
        width: 269mm; height: 182mm;
        border: 2pt solid #C8972A;
    }

    /* ── Typography ── */
    .school-name {
        font-size: 7pt;
        letter-spacing: 5pt;
        color: #C8972A;
        text-transform: uppercase;
        margin-bottom: 4pt;
    }
    .cert-title {
        font-size: 18pt;
        letter-spacing: 5pt;
        text-transform: uppercase;
        color: #FFFFFF;
        margin-top: 4pt;
        margin-bottom: 10pt;
    }
    .presented {
        font-size: 7pt;
        color: #888877;
        letter-spacing: 3pt;
        text-transform: uppercase;
        margin-bottom: 3pt;
    }
    .student-name {
        font-size: 28pt;
        font-weight: bold;
        color: #FFFFFF;
        margin-bottom: 4pt;
        line-height: 1.1;
    }
    .completion {
        font-size: 7.5pt;
        color: #888877;
        margin-bottom: 2pt;
    }
    .course-name {
        font-size: 13pt;
        color: #C8972A;
        font-style: italic;
        margin-bottom: 4pt;
    }
    .course-meta {
        font-size: 6.5pt;
        color: #555544;
        letter-spacing: 3pt;
        text-transform: uppercase;
        margin-bottom: 10pt;
    }
    .issued {
        font-size: 7pt;
        color: #666655;
        margin-bottom: 14pt;
    }
    .sig-label {
        font-size: 6pt;
        color: #555544;
        letter-spacing: 2pt;
        text-transform: uppercase;
        padding-top: 4pt;
    }
    .footer-left {
        font-size: 6pt;
        color: #3a3a2a;
        font-family: 'Courier New', monospace;
    }
    .footer-right {
        font-size: 5.5pt;
        color: #2f2f1f;
        font-family: 'Courier New', monospace;
        text-align: right;
    }
</style>
</head>
<body>

{{-- Decorative borders (absolutely positioned over the page) --}}
<div class="border-outer"></div>
<div class="border-inner"></div>

{{--
    Layout table.
    Row 1: fixed-height spacer — pushes content down to visual centre.
    Row 2: certificate content.
    Row 3: spacer (keeps footer off the bottom border edge).
    dompdf sizes rows by their explicit height, so this reliably centres the block.
--}}
<table style="width: 297mm; background: #0D0D0D; border-collapse: collapse;">

    {{-- Top spacer: approx (210mm - content_height) / 2.  Content ≈ 85mm → spacer ≈ 62mm --}}
    <tr><td style="height: 62mm; font-size: 0; line-height: 0; background: #0D0D0D;"></td></tr>

    {{-- Certificate content --}}
    <tr>
        <td style="text-align: center; vertical-align: top; padding: 0 32mm; background: #0D0D0D;">

            <div class="school-name">AcademiaCraft &nbsp;&middot;&nbsp; School of Excellence</div>

            {{-- Thin gold rule via a 1-row table (dompdf-safe) --}}
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 4pt;">
                <tr><td style="padding: 0 60mm;"><div style="border-top: 0.5pt solid #C8972A; opacity: 0.4;"></div></td></tr>
            </table>

            <div class="cert-title">Certificate of Completion</div>

            <div class="presented">This is to certify that</div>
            <div class="student-name">{{ $student->name }}</div>

            <div class="completion">has successfully completed the</div>
            <div class="course-name">{{ $course->title }}</div>
            <div class="course-meta">{{ ucfirst($course->type) }} Programme &nbsp;&middot;&nbsp; {{ $course->duration_weeks }} Weeks</div>

            <div class="issued">Issued on {{ $issuedAt }}</div>

            {{-- Signature lines --}}
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 10pt;">
                <tr>
                    <td style="width: 33%; text-align: center; padding: 0 8mm; vertical-align: bottom;">
                        <div style="border-top: 0.5pt solid #2a2a1a; padding-top: 4pt;">
                            <div class="sig-label">Principal</div>
                        </div>
                    </td>
                    <td style="width: 34%; text-align: center; padding: 0 8mm; vertical-align: bottom;">
                        <div style="border-top: 0.5pt solid #2a2a1a; padding-top: 4pt;">
                            <div class="sig-label">Academic Registrar</div>
                        </div>
                    </td>
                    <td style="width: 33%; text-align: center; padding: 0 8mm; vertical-align: bottom;">
                        <div style="border-top: 0.5pt solid #2a2a1a; padding-top: 4pt;">
                            <div class="sig-label">Date</div>
                        </div>
                    </td>
                </tr>
            </table>

            {{-- Footer: cert number left, verify URL right --}}
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td class="footer-left">Cert No: {{ $certNumber }}</td>
                    <td class="footer-right">Verify: {{ config('app.url') }}/verify/{{ $verificationCode }}</td>
                </tr>
            </table>

        </td>
    </tr>

    {{-- Bottom spacer --}}
    <tr><td style="height: 20mm; font-size: 0; line-height: 0; background: #0D0D0D;"></td></tr>

</table>

</body>
</html>
