@extends('layouts.app')

@section('title', 'All Programmes')

@section('content')

{{-- PAGE HEADER --}}
<div class="bg-ink pt-32 pb-20 px-8 relative overflow-hidden">
    <div class="absolute top-0 left-0 right-0 h-[4px] bg-gradient-to-r from-gold via-rust to-sage"></div>
    <div class="absolute right-[-80px] top-[-80px] w-[400px] h-[400px] rounded-full border border-white/[0.05] pointer-events-none"></div>
    <div class="absolute right-[80px] top-[20px] w-[220px] h-[220px] rounded-full border border-gold/[0.08] pointer-events-none"></div>

    <div class="max-w-7xl mx-auto">
        <div class="text-[0.7rem] font-bold uppercase tracking-[0.15em] text-gold flex items-center gap-2 mb-4">
            <span class="w-6 h-px bg-gold inline-block"></span> All Programmes
        </div>
        <h1 class="font-serif text-5xl font-black text-white tracking-tight leading-tight mb-4">
            Find Your <em class="text-gold italic">Perfect</em> Course
        </h1>
        <p class="text-white/40 text-lg max-w-xl leading-relaxed">
            Browse our nationally recognized Diploma and Artisan programmes. Enroll online and earn your certificate at your own pace.
        </p>

        <div class="flex gap-10 mt-10">
            <div>
                <div class="font-serif text-3xl font-black text-white">{{ $courses->count() }}</div>
                <div class="text-xs uppercase tracking-widest text-white/30 font-medium mt-0.5">Programmes</div>
            </div>
            <div class="w-px bg-white/10"></div>
            <div>
                <div class="font-serif text-3xl font-black text-white">{{ $courses->where('type','diploma')->count() }}</div>
                <div class="text-xs uppercase tracking-widest text-white/30 font-medium mt-0.5">Diploma</div>
            </div>
            <div class="w-px bg-white/10"></div>
            <div>
                <div class="font-serif text-3xl font-black text-white">{{ $courses->where('type','artisan')->count() }}</div>
                <div class="text-xs uppercase tracking-widest text-white/30 font-medium mt-0.5">Artisan</div>
            </div>
        </div>
    </div>
</div>

{{-- FILTER + GRID --}}
<div class="bg-cream min-h-screen py-16 px-8">
    <div class="max-w-7xl mx-auto">

        <div class="flex items-center justify-between mb-10">
            <div class="flex gap-2" id="filter-tabs">
                <button class="filter-tab text-sm font-semibold px-5 py-2 rounded-full border transition-all duration-200 bg-ink text-cream border-ink cursor-pointer"
                        data-filter="all">
                    All <span class="ml-1 text-xs opacity-50">{{ $courses->count() }}</span>
                </button>
                <button class="filter-tab text-sm font-semibold px-5 py-2 rounded-full border transition-all duration-200 bg-transparent text-ink/50 border-ink/20 hover:bg-ink hover:text-cream hover:border-ink cursor-pointer"
                        data-filter="diploma">
                    Diploma <span class="ml-1 text-xs opacity-50">{{ $courses->where('type','diploma')->count() }}</span>
                </button>
                <button class="filter-tab text-sm font-semibold px-5 py-2 rounded-full border transition-all duration-200 bg-transparent text-ink/50 border-ink/20 hover:bg-ink hover:text-cream hover:border-ink cursor-pointer"
                        data-filter="artisan">
                    Artisan <span class="ml-1 text-xs opacity-50">{{ $courses->where('type','artisan')->count() }}</span>
                </button>
            </div>
            <p class="text-sm text-ink/40">Showing <span id="visible-count">{{ $courses->count() }}</span> programmes</p>
        </div>

        @if($courses->isEmpty())
        <div class="text-center py-24 text-ink/30">
            <div class="text-5xl mb-4">📚</div>
            <p class="font-serif text-2xl font-bold mb-2">No courses available</p>
            <p class="text-sm">Check back soon for new programmes.</p>
        </div>
        @else
        <div class="grid grid-cols-3 gap-7" id="course-grid">
            @foreach($courses as $course)
            @php
                $isArtisan = $course->type === 'artisan';
                $gradient  = $isArtisan ? 'from-amber-950 to-amber-700' : 'from-green-950 to-green-700';
                $lc        = strtolower($course->title);
                $icon = match(true) {
                    str_contains($lc, 'business')                                   => '📊',
                    str_contains($lc, 'information') || str_contains($lc, 'it')    => '💻',
                    str_contains($lc, 'welding')                                    => '🔧',
                    str_contains($lc, 'electrical')                                 => '⚡',
                    str_contains($lc, 'building') || str_contains($lc, 'construct') => '🏗',
                    str_contains($lc, 'plumbing')                                   => '🪛',
                    $isArtisan                                                       => '🔨',
                    default                                                          => '📋',
                };
            @endphp
            <div class="course-card bg-white rounded-2xl border border-ink/10 overflow-hidden hover:-translate-y-1.5 hover:shadow-[0_20px_60px_rgba(0,0,0,0.1)] transition-all duration-300 flex flex-col"
                 data-type="{{ $course->type }}">

                <div class="h-[180px] bg-gradient-to-br {{ $gradient }} relative overflow-hidden flex items-end p-6">
                    <div class="absolute inset-0"
                         style="background-image:url(\"data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23fff' fill-opacity='0.04' fill-rule='evenodd'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/svg%3E\")">
                    </div>
                    <div class="w-12 h-12 rounded-xl bg-white/15 backdrop-blur border border-white/20 flex items-center justify-center text-2xl relative z-10">
                        {{ $icon }}
                    </div>
                    <div class="absolute top-4 right-4 text-[0.6rem] font-bold uppercase tracking-widest text-white/25">
                        {{ $course->duration_weeks }}wks
                    </div>
                </div>

                <div class="p-6 flex flex-col flex-1">
                    <span class="{{ $isArtisan ? 'badge-artisan' : 'badge-diploma' }} mb-3 self-start">
                        {{ ucfirst($course->type) }}
                    </span>
                    <h3 class="font-serif text-[1.2rem] font-bold tracking-tight leading-snug mb-2">
                        {{ $course->title }}
                    </h3>
                    <p class="text-sm text-ink/50 leading-relaxed mb-6 flex-1">
                        {{ $course->description }}
                    </p>

                    <div class="flex items-center justify-between pt-5 border-t border-ink/10">
                        <div class="flex gap-5">
                            <div>
                                <div class="text-sm font-semibold">{{ $course->duration_weeks }} Weeks</div>
                                <div class="text-[0.65rem] uppercase tracking-widest text-ink/40 mt-0.5">Duration</div>
                            </div>
                            <div>
                                <div class="text-sm font-semibold">KES {{ number_format($course->fee) }}</div>
                                <div class="text-[0.65rem] uppercase tracking-widest text-ink/40 mt-0.5">Fee</div>
                            </div>
                        </div>
                        <a href="/courses/{{ $course->slug }}"
                           class="w-9 h-9 rounded-full bg-ink text-cream flex items-center justify-center text-sm hover:bg-gold hover:text-ink transition-all duration-200">
                            →
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endif

    </div>
</div>

@endsection

@push('scripts')
<script>
    const tabs    = document.querySelectorAll('.filter-tab');
    const cards   = document.querySelectorAll('.course-card');
    const countEl = document.getElementById('visible-count');

    tabs.forEach(tab => {
        tab.addEventListener('click', function () {
            tabs.forEach(t => {
                t.classList.remove('bg-ink', 'text-cream', 'border-ink');
                t.classList.add('bg-transparent', 'text-ink/50', 'border-ink/20');
            });
            this.classList.add('bg-ink', 'text-cream', 'border-ink');
            this.classList.remove('bg-transparent', 'text-ink/50', 'border-ink/20');

            const filter = this.dataset.filter;
            let visible  = 0;
            cards.forEach(card => {
                const show = filter === 'all' || card.dataset.type === filter;
                card.style.display = show ? '' : 'none';
                if (show) visible++;
            });
            countEl.textContent = visible;
        });
    });
</script>
@endpush
