@extends('layouts.app')

@section('title', $course->title)

@section('content')

@php
    $isArtisan = $course->type === 'artisan';
    $gradient  = $isArtisan ? 'from-amber-950 via-amber-900 to-amber-700' : 'from-green-950 via-green-900 to-green-700';
    $lc        = strtolower($course->title);
    $icon = match(true) {
        str_contains($lc, 'business')                                   => '📊',
        str_contains($lc, 'information') || str_contains($lc, 'it')    => '💻',
        str_contains($lc, 'welding')                                    => '🔧',
        str_contains($lc, 'electrical')                                 => '⚡',
        str_contains($lc, 'building') || str_contains($lc, 'construct') => '🏗',
        str_contains($lc, 'plumbing')                                   => '🪛',
        $isArtisan                                                       => '🔨',
        default                                                          => '📋',
    };
@endphp

{{-- HERO --}}
<div class="bg-gradient-to-br {{ $gradient }} pt-36 pb-24 px-8 relative overflow-hidden">
    <div class="absolute top-0 left-0 right-0 h-[4px] bg-gradient-to-r from-gold via-rust to-gold"></div>
    <div class="absolute right-[-100px] top-[-100px] w-[500px] h-[500px] rounded-full border border-white/[0.05] pointer-events-none"></div>
    <div class="absolute right-[60px] bottom-[-60px] w-[280px] h-[280px] rounded-full border border-white/[0.04] pointer-events-none"></div>

    <div class="max-w-7xl mx-auto">
        {{-- Breadcrumb --}}
        <div class="flex items-center gap-2 text-[0.75rem] text-white/35 font-medium mb-8">
            <a href="/" class="hover:text-white/60 transition-colors">Home</a>
            <span>›</span>
            <a href="/courses" class="hover:text-white/60 transition-colors">Courses</a>
            <span>›</span>
            <span class="text-white/55">{{ $course->title }}</span>
        </div>

        <div class="grid grid-cols-[1fr_360px] gap-16 items-start">

            {{-- Left: course info --}}
            <div>
                <span class="{{ $isArtisan ? 'bg-yellow-500/20 text-yellow-300' : 'bg-green-500/20 text-green-300' }} text-[0.65rem] font-bold uppercase tracking-widest px-3 py-1 rounded-full inline-block mb-5">
                    {{ ucfirst($course->type) }} Programme
                </span>

                <h1 class="font-serif text-5xl font-black text-white tracking-tight leading-tight mb-5">
                    {{ $course->title }}
                </h1>

                <p class="text-white/50 text-lg leading-relaxed max-w-xl">
                    {{ $course->description }}
                </p>

                {{-- Quick stats --}}
                <div class="flex gap-8 mt-10">
                    <div>
                        <div class="font-serif text-2xl font-black text-white">{{ $course->duration_weeks }}</div>
                        <div class="text-[0.7rem] uppercase tracking-widest text-white/30 font-medium mt-0.5">Weeks</div>
                    </div>
                    <div class="w-px bg-white/10"></div>
                    <div>
                        <div class="font-serif text-2xl font-black text-white">KES {{ number_format($course->fee) }}</div>
                        <div class="text-[0.7rem] uppercase tracking-widest text-white/30 font-medium mt-0.5">Enrollment Fee</div>
                    </div>
                    <div class="w-px bg-white/10"></div>
                    <div>
                        <div class="font-serif text-2xl font-black text-white">Online</div>
                        <div class="text-[0.7rem] uppercase tracking-widest text-white/30 font-medium mt-0.5">Mode</div>
                    </div>
                </div>
            </div>

            {{-- Right: enrollment card (shown in hero column) --}}
            <div class="bg-white/10 backdrop-blur border border-white/15 rounded-2xl p-6 text-white">
                <div class="flex items-center gap-4 mb-6">
                    <div class="w-14 h-14 rounded-xl bg-white/15 border border-white/20 flex items-center justify-center text-2xl">
                        {{ $icon }}
                    </div>
                    <div>
                        <div class="text-xs uppercase tracking-widest text-white/40 mb-0.5">Course Fee</div>
                        <div class="font-serif text-2xl font-black text-gold">KES {{ number_format($course->fee) }}</div>
                    </div>
                </div>

                <div class="space-y-3 mb-6">
                    <div class="flex justify-between text-sm">
                        <span class="text-white/45">Duration</span>
                        <span class="font-semibold">{{ $course->duration_weeks }} Weeks</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-white/45">Level</span>
                        <span class="font-semibold">{{ $isArtisan ? 'Artisan / Trade' : 'Diploma' }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-white/45">Mode</span>
                        <span class="font-semibold">Online / Flexible</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-white/45">Certificate</span>
                        <span class="font-semibold text-gold">✓ Nationally Recognized</span>
                    </div>
                </div>

                @auth
                    <form method="POST" action="{{ route('enroll', $course) }}">
                        @csrf
                        <button type="submit"
                                class="w-full bg-gold text-ink font-bold py-3.5 rounded-xl hover:bg-gold-light transition-all duration-200 text-sm tracking-wide">
                            Enroll Now — KES {{ number_format($course->fee) }}
                        </button>
                    </form>
                @else
                    <a href="/login"
                       class="block w-full bg-gold text-ink font-bold py-3.5 rounded-xl hover:bg-gold-light transition-all duration-200 text-sm tracking-wide text-center">
                        Sign In to Enroll
                    </a>
                    <p class="text-center text-white/30 text-xs mt-3">
                        No account? <a href="/register" class="text-gold hover:underline">Register free →</a>
                    </p>
                @endauth
            </div>

        </div>
    </div>
</div>

{{-- DETAIL SECTION --}}
<div class="bg-cream py-20 px-8">
    <div class="max-w-7xl mx-auto grid grid-cols-[1fr_360px] gap-16">

        {{-- Left: about the course --}}
        <div>
            {{-- Flash messages --}}
            @if(session('success'))
                <div class="bg-green-50 border border-green-200 text-green-800 px-5 py-3.5 rounded-xl text-sm font-medium mb-8 flex items-center gap-2">
                    <span>✓</span> {{ session('success') }}
                </div>
            @endif
            @if(session('error'))
                <div class="bg-red-50 border border-red-200 text-red-800 px-5 py-3.5 rounded-xl text-sm font-medium mb-8 flex items-center gap-2">
                    <span>✕</span> {{ session('error') }}
                </div>
            @endif

            <div class="text-[0.7rem] font-bold uppercase tracking-[0.15em] text-gold flex items-center gap-2 mb-3">
                <span class="w-6 h-px bg-gold inline-block"></span> About This Programme
            </div>
            <h2 class="font-serif text-3xl font-black tracking-tight mb-5">What You'll Learn</h2>
            <p class="text-ink/60 leading-relaxed mb-8 text-base">
                {{ $course->description }} This programme is designed to give you hands-on, practical skills that are in demand across Kenya and the wider region. Upon completion, you will receive a nationally recognized {{ ucfirst($course->type) }} certificate.
            </p>

            {{-- Programme highlights --}}
            <div class="grid grid-cols-2 gap-4 mb-12">
                @foreach([
                    ['icon' => '🎯', 'title' => 'Practical Skills', 'desc' => 'Hands-on training with real-world application'],
                    ['icon' => '🏆', 'title' => 'Recognized Certificate', 'desc' => 'Nationally accredited upon completion'],
                    ['icon' => '⏱', 'title' => 'Flexible Learning', 'desc' => 'Study at your own pace, online'],
                    ['icon' => '👨‍🏫', 'title' => 'Expert Instructors', 'desc' => 'Guidance from experienced professionals'],
                ] as $highlight)
                <div class="bg-white rounded-xl border border-ink/10 p-5 flex gap-4 items-start">
                    <span class="text-xl shrink-0">{{ $highlight['icon'] }}</span>
                    <div>
                        <div class="font-semibold text-sm mb-0.5">{{ $highlight['title'] }}</div>
                        <div class="text-xs text-ink/45 leading-relaxed">{{ $highlight['desc'] }}</div>
                    </div>
                </div>
                @endforeach
            </div>

            {{-- Curriculum / Units by Semester --}}
            @if($course->units->count())
            @php $unitsBySemester = $course->units->groupBy('semester'); @endphp
            <div class="mb-12">
                <div class="text-[0.7rem] font-bold uppercase tracking-[0.15em] text-gold flex items-center gap-2 mb-3">
                    <span class="w-6 h-px bg-gold inline-block"></span> Course Curriculum
                </div>
                <h2 class="font-serif text-3xl font-black tracking-tight mb-6">Programme Structure</h2>

                <div class="space-y-3">
                    @foreach($unitsBySemester as $semNum => $units)
                        <div class="bg-white rounded-2xl border border-ink/10 overflow-hidden">
                            <button type="button"
                                    onclick="this.nextElementSibling.classList.toggle('hidden'); this.querySelector('.chev').classList.toggle('rotate-180')"
                                    class="w-full flex items-center justify-between px-6 py-4 text-left hover:bg-black/[0.015] transition-colors">
                                <div class="flex items-center gap-3">
                                    <span class="w-8 h-8 rounded-lg bg-gold/10 text-gold text-sm font-bold flex items-center justify-center shrink-0">{{ $semNum }}</span>
                                    <div>
                                        <span class="font-semibold text-ink text-sm">Semester {{ $semNum }}</span>
                                        <span class="text-ink/40 text-xs ml-2">{{ $units->count() }} {{ Str::plural('unit', $units->count()) }}</span>
                                    </div>
                                </div>
                                <svg class="chev w-4 h-4 text-ink/30 transition-transform duration-200 shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div class="hidden border-t border-ink/[0.06]">
                                @foreach($units as $unit)
                                    <div class="flex items-start gap-3 px-6 py-3.5 border-b border-ink/[0.04] last:border-0">
                                        <span class="text-gold mt-0.5 shrink-0 text-xs">✦</span>
                                        <div class="min-w-0">
                                            <div class="flex items-center gap-2 flex-wrap">
                                                @if($unit->unit_code)
                                                    <span class="font-mono text-[0.65rem] bg-ink/5 text-ink/50 px-1.5 py-0.5 rounded">{{ $unit->unit_code }}</span>
                                                @endif
                                                <span class="text-sm font-medium text-ink">{{ $unit->unit_name }}</span>
                                            </div>
                                            @if($unit->description)
                                                <p class="text-xs text-ink/45 mt-0.5 leading-relaxed">{{ $unit->description }}</p>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif

            {{-- Programme details table --}}
            <h3 class="font-serif text-xl font-bold tracking-tight mb-5">Programme Details</h3>
            <div class="bg-white rounded-2xl border border-ink/10 overflow-hidden">
                @foreach([
                    ['label' => 'Programme Title',  'value' => $course->title],
                    ['label' => 'Type',              'value' => ucfirst($course->type) . ' Programme'],
                    ['label' => 'Duration',          'value' => $course->duration_weeks . ' Weeks'],
                    ['label' => 'Mode of Study',     'value' => 'Online / Flexible Schedule'],
                    ['label' => 'Enrollment Fee',    'value' => 'KES ' . number_format($course->fee)],
                    ['label' => 'Award',             'value' => ($isArtisan ? 'Artisan Certificate' : 'Diploma Certificate') . ' (Nationally Recognized)'],
                ] as $row)
                <div class="flex items-center px-6 py-4 border-b border-ink/[0.07] last:border-0">
                    <span class="text-xs uppercase tracking-widest text-ink/35 font-bold w-40 shrink-0">{{ $row['label'] }}</span>
                    <span class="text-sm font-medium text-ink">{{ $row['value'] }}</span>
                </div>
                @endforeach
            </div>
        </div>

        {{-- Right: sticky enrollment sidebar --}}
        <div class="sticky top-28 self-start">
            <div class="bg-ink rounded-2xl overflow-hidden shadow-[0_20px_60px_rgba(0,0,0,0.2)]">
                <div class="h-[5px] bg-gradient-to-r from-gold via-rust to-gold"></div>
                <div class="p-7">
                    <div class="text-[0.65rem] uppercase tracking-widest text-white/35 mb-1">Enrollment Fee</div>
                    <div class="font-serif text-4xl font-black text-gold mb-6">KES {{ number_format($course->fee) }}</div>

                    <div class="space-y-3 mb-7">
                        <div class="flex items-center gap-3 text-sm text-white/55">
                            <span class="text-gold">✓</span> {{ $course->duration_weeks }}-week programme
                        </div>
                        <div class="flex items-center gap-3 text-sm text-white/55">
                            <span class="text-gold">✓</span> Online, self-paced learning
                        </div>
                        <div class="flex items-center gap-3 text-sm text-white/55">
                            <span class="text-gold">✓</span> Nationally recognized certificate
                        </div>
                        <div class="flex items-center gap-3 text-sm text-white/55">
                            <span class="text-gold">✓</span> Instant digital certificate on completion
                        </div>
                        <div class="flex items-center gap-3 text-sm text-white/55">
                            <span class="text-gold">✓</span> Expert instructor support
                        </div>
                    </div>

                    @auth
                        <form method="POST" action="{{ route('enroll', $course) }}">
                            @csrf
                            <button type="submit"
                                    class="w-full bg-gold text-ink font-bold py-4 rounded-xl hover:bg-gold-light transition-all duration-200 text-sm tracking-wide mb-3">
                                Enroll Now →
                            </button>
                        </form>
                    @else
                        <a href="/login"
                           class="block w-full bg-gold text-ink font-bold py-4 rounded-xl hover:bg-gold-light transition-all duration-200 text-sm tracking-wide text-center mb-3">
                            Sign In to Enroll
                        </a>
                        <p class="text-center text-white/25 text-xs">
                            New student? <a href="/register" class="text-gold hover:underline">Register free →</a>
                        </p>
                    @endauth

                    <div class="mt-5 pt-5 border-t border-white/[0.08] text-center">
                        <p class="text-[0.7rem] text-white/20 leading-relaxed">
                            ✦ Secure enrollment · Instant access
                        </p>
                    </div>
                </div>
            </div>

            {{-- Back link --}}
            <a href="/courses" class="flex items-center gap-2 text-sm text-ink/40 hover:text-ink transition-colors mt-5 justify-center">
                ← Back to All Courses
            </a>
        </div>

    </div>
</div>

@endsection
