@extends('layouts.dashboard')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')

@php
    $firstName    = explode(' ', auth()->user()->name)[0];
    $activeCount  = $enrollments->where('status', '!=', 'completed')->count();
    $certsCount   = $certificates->count();
    $totalCount   = $enrollments->count();
    $overallPct   = $totalCount > 0 ? round($certsCount / $totalCount * 100) : 0;
@endphp

{{-- WELCOME BANNER --}}
<div class="bg-ink rounded-2xl px-12 py-10 flex items-center justify-between relative overflow-hidden mb-8">
    <div class="absolute right-[-60px] top-[-60px] w-[300px] h-[300px] rounded-full border border-gold/20 pointer-events-none"></div>
    <div class="absolute right-[100px] bottom-[-80px] w-[200px] h-[200px] rounded-full border border-gold/10 pointer-events-none"></div>

    <div class="relative z-10">
        <p class="text-[0.78rem] font-semibold uppercase tracking-widest text-gold mb-2">✦ Welcome Back</p>
        <h2 class="font-serif text-[1.75rem] font-black text-white tracking-tight leading-tight">
            Good morning, <em class="text-gold italic">{{ $firstName }}</em>
        </h2>
        <span class="block mt-2 text-sm text-white/40">
            @if($activeCount > 0)
                You have {{ $activeCount }} active {{ Str::plural('course', $activeCount) }} in progress. Keep going!
            @else
                You have no active courses. Enroll in a course to get started!
            @endif
        </span>
    </div>

    <div class="relative z-10 text-center bg-white/5 border border-white/10 rounded-2xl px-8 py-6 text-white">
        <div class="font-serif text-[2.5rem] font-black text-gold leading-none">{{ $overallPct }}%</div>
        <div class="text-[0.72rem] uppercase tracking-widest text-white/40 mt-1">Overall Progress</div>
    </div>
</div>

{{-- STATS ROW --}}
<div class="grid grid-cols-4 gap-5 mb-8">
    <div class="bg-white rounded-2xl border border-ink/10 p-6 flex items-center gap-4 hover:-translate-y-0.5 hover:shadow-lg transition-all duration-200">
        <div class="w-12 h-12 rounded-xl bg-gold/[0.12] flex items-center justify-center text-xl shrink-0">📚</div>
        <div>
            <div class="font-serif text-[1.6rem] font-black tracking-tight leading-none">{{ $activeCount }}</div>
            <div class="text-[0.72rem] uppercase tracking-widest text-ink/40 font-medium mt-1">Active Courses</div>
        </div>
    </div>
    <div class="bg-white rounded-2xl border border-ink/10 p-6 flex items-center gap-4 hover:-translate-y-0.5 hover:shadow-lg transition-all duration-200">
        <div class="w-12 h-12 rounded-xl bg-sage/[0.12] flex items-center justify-center text-xl shrink-0">🎓</div>
        <div>
            <div class="font-serif text-[1.6rem] font-black tracking-tight leading-none">{{ $certsCount }}</div>
            <div class="text-[0.72rem] uppercase tracking-widest text-ink/40 font-medium mt-1">Certificates Earned</div>
        </div>
    </div>
    <div class="bg-white rounded-2xl border border-ink/10 p-6 flex items-center gap-4 hover:-translate-y-0.5 hover:shadow-lg transition-all duration-200">
        <div class="w-12 h-12 rounded-xl bg-rust/10 flex items-center justify-center text-xl shrink-0">✅</div>
        <div>
            <div class="font-serif text-[1.6rem] font-black tracking-tight leading-none">{{ $certsCount }}</div>
            <div class="text-[0.72rem] uppercase tracking-widest text-ink/40 font-medium mt-1">Courses Completed</div>
        </div>
    </div>
    <div class="bg-white rounded-2xl border border-ink/10 p-6 flex items-center gap-4 hover:-translate-y-0.5 hover:shadow-lg transition-all duration-200">
        <div class="w-12 h-12 rounded-xl bg-blue-500/10 flex items-center justify-center text-xl shrink-0">📋</div>
        <div>
            <div class="font-serif text-[1.6rem] font-black tracking-tight leading-none">{{ $totalCount }}</div>
            <div class="text-[0.72rem] uppercase tracking-widest text-ink/40 font-medium mt-1">Total Enrolled</div>
        </div>
    </div>
</div>

{{-- MAIN TWO-COL GRID --}}
<div class="grid grid-cols-[1.6fr_1fr] gap-6 mb-8">

    {{-- ENROLLED COURSES --}}
    <div class="bg-white rounded-2xl border border-ink/10 overflow-hidden">
        <div class="px-7 py-5 border-b border-ink/10 flex items-center justify-between">
            <span class="font-serif text-[1.05rem] font-bold tracking-tight">My Enrolled Courses</span>
            <a href="#" class="text-[0.78rem] text-gold font-semibold hover:underline">View All →</a>
        </div>
        <div class="p-5 flex flex-col gap-4">
            @forelse($enrollments as $enrollment)
            <div class="flex items-center gap-4 p-5 rounded-xl bg-[#F0F4F8] border border-ink/10 hover:border-gold/30 hover:bg-gold/[0.04] transition-all duration-200 cursor-pointer">
                <div class="w-11 h-11 rounded-[10px] flex items-center justify-center text-xl shrink-0
                    {{ $enrollment->course->type === 'diploma' ? 'bg-gradient-to-br from-green-950 to-green-700' : 'bg-gradient-to-br from-amber-950 to-amber-700' }}">
                    {{ $enrollment->course->type === 'diploma' ? '📊' : '🔧' }}
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold truncate">{{ $enrollment->course->title }}</div>
                    <div class="text-[0.68rem] uppercase tracking-widest text-ink/40 font-semibold mt-0.5">
                        {{ ucfirst($enrollment->course->type) }} · {{ $enrollment->course->duration_weeks }} Weeks
                    </div>
                </div>
                <div class="w-24 shrink-0">
                    @php $pct = $enrollment->status === 'completed' ? 100 : 0; @endphp
                    <div class="flex justify-between text-[0.68rem] text-ink/40 font-medium mb-1">
                        <span>Progress</span><span>{{ $pct }}%</span>
                    </div>
                    <div class="h-1.5 bg-ink/10 rounded-full overflow-hidden">
                        <div class="h-full rounded-full transition-all duration-700
                            {{ $enrollment->status === 'completed' ? 'bg-sage' : 'bg-gold' }}"
                            style="width: {{ $pct }}%"></div>
                    </div>
                </div>
            </div>
            @empty
            <div class="text-center py-12 text-ink/35">
                <div class="text-4xl mb-3">📚</div>
                <p class="text-sm leading-relaxed">You haven't enrolled in any courses yet.<br>
                    <a href="/courses" class="text-gold font-semibold hover:underline">Browse courses →</a>
                </p>
            </div>
            @endforelse
        </div>
    </div>

    {{-- CERTIFICATES --}}
    <div class="bg-white rounded-2xl border border-ink/10 overflow-hidden">
        <div class="px-7 py-5 border-b border-ink/10 flex items-center justify-between">
            <span class="font-serif text-[1.05rem] font-bold tracking-tight">My Certificates</span>
            <a href="#" class="text-[0.78rem] text-gold font-semibold hover:underline">View All →</a>
        </div>
        <div class="p-5 flex flex-col gap-3">
            @forelse($certificates as $enrollment)
            <div class="flex items-center gap-4 p-4 rounded-xl border border-ink/10 hover:border-gold/40 hover:bg-gold/[0.03] transition-all duration-200 cursor-pointer">
                <div class="w-11 h-11 rounded-lg bg-ink flex items-center justify-center text-xl shrink-0">🏅</div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold truncate">{{ $enrollment->course->title }}</div>
                    <div class="text-[0.68rem] text-ink/40 mt-0.5">
                        Issued · {{ $enrollment->completed_at ? \Carbon\Carbon::parse($enrollment->completed_at)->format('d M Y') : 'N/A' }}
                        @if($enrollment->certificate)
                            · #{{ $enrollment->certificate->certificate_number }}
                        @endif
                    </div>
                </div>
                @if($enrollment->certificate)
                <a href="{{ route('certificate.download', $enrollment->certificate->id) }}"
                   class="w-8 h-8 rounded-lg bg-gold/10 border-none flex items-center justify-center text-gold text-sm hover:bg-gold hover:text-white transition-all duration-200 shrink-0"
                   title="Download Certificate">⬇</a>
                @endif
            </div>
            @empty
            <div class="text-center py-12 text-ink/35">
                <div class="text-4xl mb-3">🎓</div>
                <p class="text-sm leading-relaxed">Complete a course to earn your first certificate.</p>
            </div>
            @endforelse
        </div>
    </div>
</div>

{{-- BROWSE MORE COURSES --}}
@if($courses->count() > 0)
<div>
    <div class="flex items-center justify-between mb-5">
        <div class="font-serif text-[1.2rem] font-black tracking-tight">Browse More Courses</div>
        <div class="flex gap-2" id="filter-tabs">
            <button class="filter-tab bg-ink text-white border-ink text-[0.75rem] font-semibold border rounded-full px-4 py-1.5 cursor-pointer transition-all duration-200" data-filter="all">All</button>
            <button class="filter-tab bg-white text-ink/50 border-ink/20 text-[0.75rem] font-semibold border rounded-full px-4 py-1.5 cursor-pointer transition-all duration-200 hover:bg-ink hover:text-white hover:border-ink" data-filter="diploma">Diploma</button>
            <button class="filter-tab bg-white text-ink/50 border-ink/20 text-[0.75rem] font-semibold border rounded-full px-4 py-1.5 cursor-pointer transition-all duration-200 hover:bg-ink hover:text-white hover:border-ink" data-filter="artisan">Artisan</button>
        </div>
    </div>

    <div class="grid grid-cols-3 gap-5">
        @foreach($courses as $course)
        <div class="bg-white rounded-2xl border border-ink/10 overflow-hidden cursor-pointer hover:-translate-y-1 hover:shadow-[0_12px_36px_rgba(0,0,0,0.08)] transition-all duration-200 browse-card" data-type="{{ $course->type }}">
            <div class="h-[100px] flex items-center pl-5 relative
                {{ $course->type === 'diploma' ? 'bg-gradient-to-br from-green-950 to-green-700' : 'bg-gradient-to-br from-amber-950 to-amber-700' }}">
                <div class="w-11 h-11 rounded-[10px] bg-white/15 backdrop-blur border border-white/20 flex items-center justify-center text-xl">
                    {{ $course->type === 'diploma' ? '📊' : '🔧' }}
                </div>
            </div>
            <div class="p-4">
                <span class="{{ $course->type === 'diploma' ? 'badge-diploma' : 'badge-artisan' }} mb-2 inline-block">
                    {{ ucfirst($course->type) }}
                </span>
                <div class="text-[0.9rem] font-semibold leading-snug mb-3 tracking-tight">{{ $course->title }}</div>
                <div class="flex items-center justify-between pt-3 border-t border-ink/10">
                    <span class="text-[0.72rem] text-ink/40 font-medium">{{ $course->duration_weeks }} Weeks · KES {{ number_format($course->fee) }}</span>
                    <form method="POST" action="{{ route('enroll', $course) }}">
                        @csrf
                        <button type="submit" class="bg-ink text-white text-[0.72rem] font-bold py-1.5 px-3.5 rounded-lg hover:bg-gold hover:text-ink transition-all duration-200 inline-flex items-center gap-1">
                            Enroll →
                        </button>
                    </form>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endif

@endsection

@push('scripts')
<script>
    // Filter tabs
    const tabs = document.querySelectorAll('.filter-tab');
    const cards = document.querySelectorAll('.browse-card');

    tabs.forEach(tab => {
        tab.addEventListener('click', function () {
            tabs.forEach(t => {
                t.classList.remove('bg-ink', 'text-white', 'border-ink');
                t.classList.add('bg-white', 'text-ink/50', 'border-ink/20');
            });
            this.classList.add('bg-ink', 'text-white', 'border-ink');
            this.classList.remove('bg-white', 'text-ink/50', 'border-ink/20');

            const filter = this.dataset.filter;
            cards.forEach(card => {
                card.style.display = (filter === 'all' || card.dataset.type === filter) ? '' : 'none';
            });
        });
    });
</script>
@endpush
