<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin Panel') — AcademiaCraft</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&family=Playfair+Display:wght@600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-[#F0EDE8] font-sans antialiased">

<div class="flex min-h-screen">

    {{-- ── Sidebar ── --}}
    <aside class="fixed top-0 left-0 h-full w-[260px] bg-ink text-white flex flex-col z-30 overflow-y-auto">

        {{-- Logo --}}
        <div class="px-6 py-6 border-b border-white/10">
            <a href="{{ route('admin.dashboard') }}" class="flex items-center gap-3">
                <div class="w-9 h-9 bg-gold rounded-lg flex items-center justify-center font-bold text-ink text-sm">AC</div>
                <div>
                    <div class="font-semibold text-sm leading-none">AcademiaCraft</div>
                    <div class="text-[10px] text-white/40 mt-0.5 uppercase tracking-widest">Admin Panel</div>
                </div>
            </a>
        </div>

        {{-- Nav --}}
        <nav class="flex-1 px-4 py-6 space-y-1">
            @php
                $navItems = [
                    ['route' => 'admin.dashboard',          'label' => 'Dashboard',    'icon' => '▣'],
                    ['route' => 'admin.courses.index',      'label' => 'Courses',      'icon' => '◈'],
                    ['route' => 'admin.enrollments.index',  'label' => 'Enrollments',  'icon' => '◎'],
                ];
            @endphp
            @foreach ($navItems as $item)
                @php $active = request()->routeIs($item['route'] . '*'); @endphp
                <a href="{{ route($item['route']) }}"
                   class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm transition-all duration-150
                          {{ $active ? 'bg-gold/15 text-gold border-l-[3px] border-gold pl-[9px]' : 'text-white/60 hover:text-white hover:bg-white/5' }}">
                    <span class="text-base leading-none">{{ $item['icon'] }}</span>
                    <span class="font-medium">{{ $item['label'] }}</span>
                </a>
            @endforeach
        </nav>

        {{-- Admin info + logout --}}
        <div class="px-4 py-5 border-t border-white/10">
            <div class="flex items-center gap-3 mb-4">
                <div class="w-8 h-8 rounded-full bg-gold/20 flex items-center justify-center text-gold font-semibold text-xs">
                    {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
                </div>
                <div class="min-w-0">
                    <div class="text-sm font-medium truncate">{{ auth()->user()->name }}</div>
                    <div class="text-[11px] text-white/40 truncate">Administrator</div>
                </div>
            </div>
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit"
                        class="w-full flex items-center gap-2 px-3 py-2 rounded-lg text-sm text-white/50 hover:text-white hover:bg-white/5 transition-colors">
                    <span>↩</span> Log Out
                </button>
            </form>
            <a href="{{ route('dashboard') }}"
               class="mt-1 w-full flex items-center gap-2 px-3 py-2 rounded-lg text-sm text-white/50 hover:text-white hover:bg-white/5 transition-colors">
                <span>⟵</span> Student View
            </a>
        </div>
    </aside>

    {{-- ── Main content ── --}}
    <div class="ml-[260px] flex-1 flex flex-col min-h-screen">

        {{-- Topbar --}}
        <header class="sticky top-0 z-20 bg-[#F0EDE8]/95 backdrop-blur border-b border-black/[0.06] px-8 py-4 flex items-center justify-between">
            <div>
                <h1 class="font-serif text-xl text-ink font-semibold">@yield('heading', 'Admin Panel')</h1>
                <p class="text-xs text-ink/40 mt-0.5">{{ now()->format('l, d F Y') }}</p>
            </div>
            @hasSection('header-actions')
                <div>@yield('header-actions')</div>
            @endif
        </header>

        {{-- Flash messages --}}
        <div class="px-8 pt-6">
            @if (session('success'))
                <div class="flex items-center gap-3 px-4 py-3 rounded-xl bg-sage/10 border border-sage/30 text-sage text-sm mb-4">
                    <span>✓</span> {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="flex items-center gap-3 px-4 py-3 rounded-xl bg-rust/10 border border-rust/30 text-rust text-sm mb-4">
                    <span>✕</span> {{ session('error') }}
                </div>
            @endif
        </div>

        {{-- Page content --}}
        <main class="flex-1 px-8 pb-10">
            @yield('content')
        </main>
    </div>
</div>

@stack('scripts')
</body>
</html>
