<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'AcademiaCraft')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-cream min-h-screen">

    <!-- NAVIGATION -->
    <nav class="fixed top-0 left-0 right-0 z-50 bg-cream/90 backdrop-blur border-b border-black/10">
        <div class="max-w-7xl mx-auto px-8 py-4 flex items-center justify-between">

            <!-- Logo -->
            <a href="/" class="flex items-center gap-3">
                <div class="w-10 h-10 bg-ink rounded-lg flex items-center justify-center">
                    <span class="text-gold font-serif font-black text-sm">AC</span>
                </div>
                <span class="font-serif font-bold text-xl text-ink">
                    Academia<span class="text-gold">Craft</span>
                </span>
            </a>

            <!-- Links -->
            <div class="flex items-center gap-8">
                <a href="/" class="text-sm font-medium text-ink/60 hover:text-ink transition">Home</a>
                <a href="/courses" class="text-sm font-medium text-ink/60 hover:text-ink transition">Courses</a>
                @auth
                    <a href="/dashboard" class="text-sm font-medium text-ink/60 hover:text-ink transition">Dashboard</a>
                @endauth
                <a href="#" class="text-sm font-medium text-ink/60 hover:text-ink transition">About</a>
            </div>

            <!-- Auth Buttons -->
            <div class="flex items-center gap-3">
                @auth
                    <span class="text-sm text-ink/50">Hi, {{ auth()->user()->name }}</span>
                    <form method="POST" action="/logout" class="inline">
                        @csrf
                        <button type="submit" class="btn-outline text-sm py-2 px-4">
                            Logout
                        </button>
                    </form>
                @else
                    <a href="/login" class="btn-outline text-sm py-2 px-4">Sign In</a>
                    <a href="/register" class="btn-primary text-sm py-2 px-4">Enroll Now →</a>
                @endauth
            </div>
        </div>
    </nav>

    <!-- FLASH MESSAGES -->
    <div class="fixed top-20 right-6 z-50 flex flex-col gap-3 w-80">
        @if(session('success'))
            <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-xl text-sm font-medium shadow-lg">
                ✓ {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-xl text-sm font-medium shadow-lg">
                ✕ {{ session('error') }}
            </div>
        @endif
    </div>

    <!-- PAGE CONTENT -->
    <main class="pt-20">
        @yield('content')
    </main>

    <!-- FOOTER -->
    <footer class="bg-ink text-cream mt-24">
        <div class="max-w-7xl mx-auto px-8 py-16 grid grid-cols-4 gap-12">
            <div class="col-span-2">
                <div class="flex items-center gap-3 mb-4">
                    <div class="w-10 h-10 bg-gold rounded-lg flex items-center justify-center">
                        <span class="font-serif font-black text-sm text-ink">AC</span>
                    </div>
                    <span class="font-serif font-bold text-xl">
                        Academia<span class="text-gold">Craft</span>
                    </span>
                </div>
                <p class="text-cream/40 text-sm leading-relaxed max-w-xs">
                    Kenya's trusted institute for Diploma and Artisan skills training. Building careers since 2010.
                </p>
            </div>
            <div>
                <h4 class="text-xs font-bold uppercase tracking-widest text-gold mb-4">Programmes</h4>
                <ul class="space-y-2">
                    <li><a href="/courses" class="text-cream/40 text-sm hover:text-cream transition">Diploma Courses</a></li>
                    <li><a href="/courses" class="text-cream/40 text-sm hover:text-cream transition">Artisan Courses</a></li>
                </ul>
            </div>
            <div>
                <h4 class="text-xs font-bold uppercase tracking-widest text-gold mb-4">Student</h4>
                <ul class="space-y-2">
                    <li><a href="/register" class="text-cream/40 text-sm hover:text-cream transition">Register</a></li>
                    <li><a href="/login" class="text-cream/40 text-sm hover:text-cream transition">Login</a></li>
                    <li><a href="/dashboard" class="text-cream/40 text-sm hover:text-cream transition">My Dashboard</a></li>
                </ul>
            </div>
        </div>
        <div class="border-t border-white/10 max-w-7xl mx-auto px-8 py-6 flex justify-between">
            <p class="text-cream/20 text-xs">© 2026 AcademiaCraft Institute. All rights reserved.</p>
            <p class="text-cream/20 text-xs">Privacy Policy · Terms of Use</p>
        </div>
    </footer>

</body>
</html>
