<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Dashboard') — AcademiaCraft</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-[#F0F4F8] font-sans text-ink flex min-h-screen">

    <!-- SIDEBAR -->
    <aside class="fixed left-0 top-0 bottom-0 w-[260px] bg-ink flex flex-col z-50">

        <!-- Logo -->
        <div class="px-6 py-7 border-b border-white/[0.07] flex items-center gap-3">
            <div class="w-9 h-9 bg-gold rounded-lg flex items-center justify-center font-serif font-black text-sm text-ink shrink-0">AC</div>
            <span class="font-serif font-bold text-base text-white">Academia<span class="text-gold">Craft</span></span>
        </div>

        <!-- Nav -->
        <nav class="flex-1 py-6 overflow-y-auto">
            <div class="text-[0.6rem] tracking-[0.15em] uppercase text-white/25 font-bold px-6 mb-2">Main</div>

            <a href="/dashboard" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium transition-all duration-200 {{ request()->routeIs('dashboard') ? 'text-white bg-gold/[0.12] border-l-[3px] border-gold' : 'text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent' }}">
                <span class="w-5 text-center shrink-0">⊞</span> Dashboard
            </a>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">📚</span> My Courses
            </a>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">🎓</span> Certificates
            </a>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">📋</span> Progress
            </a>

            <div class="text-[0.6rem] tracking-[0.15em] uppercase text-white/25 font-bold px-6 mb-2 mt-5">Explore</div>
            <a href="/courses" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">🔍</span> Browse Courses
            </a>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">📅</span> Schedule
            </a>

            <div class="text-[0.6rem] tracking-[0.15em] uppercase text-white/25 font-bold px-6 mb-2 mt-5">Account</div>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">👤</span> My Profile
            </a>
            <a href="#" class="flex items-center gap-3 px-6 py-2.5 text-sm font-medium text-white/45 hover:text-white hover:bg-white/[0.04] border-l-[3px] border-transparent transition-all duration-200">
                <span class="w-5 text-center shrink-0">⚙</span> Settings
            </a>
        </nav>

        <!-- User footer -->
        <div class="px-6 py-5 border-t border-white/[0.07]">
            <div class="flex items-center gap-3">
                <div class="w-9 h-9 rounded-full bg-gradient-to-br from-gold to-rust flex items-center justify-center font-serif font-bold text-sm text-ink shrink-0">
                    {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-white truncate">{{ auth()->user()->name }}</div>
                    <div class="text-[0.68rem] text-white/30 mt-0.5">Student</div>
                </div>
                <form method="POST" action="/logout">
                    @csrf
                    <button type="submit" title="Logout" class="text-white/25 hover:text-white/60 transition-colors text-base bg-transparent border-none cursor-pointer p-1">⇥</button>
                </form>
            </div>
        </div>
    </aside>

    <!-- MAIN CONTENT AREA -->
    <main class="ml-[260px] flex-1 flex flex-col min-h-screen">

        <!-- TOPBAR -->
        <div class="bg-white border-b border-ink/10 px-10 py-4 flex items-center justify-between sticky top-0 z-40">
            <div>
                <h1 class="font-serif text-[1.4rem] font-black tracking-tight">@yield('page-title', 'Dashboard')</h1>
                <p class="text-xs text-ink/40 mt-0.5">{{ now()->format('l, d F Y') }}</p>
            </div>
            <div class="flex items-center gap-3">
                <div class="relative w-[38px] h-[38px] rounded-lg bg-[#F0F4F8] border border-ink/10 flex items-center justify-center cursor-pointer hover:bg-cream transition-colors text-base">
                    🔔
                    <span class="absolute top-1.5 right-1.5 w-[7px] h-[7px] rounded-full bg-rust border-[1.5px] border-white"></span>
                </div>
                <a href="/courses" class="bg-gold text-ink text-xs font-bold py-2 px-5 rounded-lg hover:bg-gold-light transition-all duration-200 inline-flex items-center gap-1.5">+ Enroll in Course</a>
            </div>
        </div>

        <!-- PAGE CONTENT -->
        <div class="p-10 flex-1">
            @if(session('success'))
                <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-xl text-sm font-medium mb-6">
                    ✓ {{ session('success') }}
                </div>
            @endif
            @if(session('error'))
                <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-xl text-sm font-medium mb-6">
                    ✕ {{ session('error') }}
                </div>
            @endif

            @yield('content')
        </div>
    </main>

    @stack('scripts')
</body>
</html>
