<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Certificate — AcademiaCraft</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&family=Playfair+Display:wght@600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-ink text-white font-sans antialiased min-h-screen flex flex-col">

    {{-- Header --}}
    <header class="border-b border-white/10 px-8 py-5">
        <div class="max-w-6xl mx-auto flex items-center justify-between">
            <a href="/" class="flex items-center gap-3">
                <div class="w-8 h-8 bg-gold rounded-lg flex items-center justify-center font-bold text-ink text-xs">AC</div>
                <span class="font-serif text-white font-semibold">AcademiaCraft</span>
            </a>
            <a href="{{ route('login') }}" class="text-sm text-white/50 hover:text-white transition-colors">Sign in →</a>
        </div>
    </header>

    {{-- Hero --}}
    <main class="flex-1 flex items-center justify-center px-6 py-16">
        <div class="max-w-lg w-full text-center">

            {{-- Badge --}}
            <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full border border-gold/30 bg-gold/10 text-gold text-xs font-medium mb-8 uppercase tracking-widest">
                Certificate Verification
            </div>

            <h1 class="font-serif text-4xl md:text-5xl font-bold text-white mb-4">
                Verify a<br><span class="text-gold">Certificate</span>
            </h1>
            <p class="text-white/50 text-base mb-10">
                Enter the verification code printed on the certificate to confirm its authenticity.
            </p>

            {{-- Form --}}
            <form method="POST" action="{{ route('verify.check') }}" class="space-y-4">
                @csrf
                <div>
                    <input type="text" name="code" value="{{ old('code') }}"
                           placeholder="e.g. 550e8400-e29b-41d4-a716-446655440000"
                           autofocus
                           class="w-full px-5 py-4 rounded-2xl bg-white/[0.07] border border-white/15 text-white text-sm font-mono
                                  placeholder-white/30 focus:outline-none focus:border-gold focus:ring-2 focus:ring-gold/20 transition-all
                                  @error('code') border-rust @enderror">
                    @error('code')
                        <p class="mt-2 text-xs text-rust text-left">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit"
                        class="w-full py-4 bg-gold text-ink font-bold text-sm rounded-2xl hover:bg-gold-light transition-colors shadow-lg">
                    Verify Certificate
                </button>
            </form>

            {{-- Info --}}
            <div class="mt-10 pt-8 border-t border-white/10 grid grid-cols-3 gap-6 text-center">
                @foreach ([['icon' => '◆', 'label' => 'Instant', 'sub' => 'Real-time check'], ['icon' => '◎', 'label' => 'Secure', 'sub' => 'UUID-based'], ['icon' => '✓', 'label' => 'Trusted', 'sub' => 'Official records']] as $item)
                    <div>
                        <div class="text-gold text-xl mb-2">{{ $item['icon'] }}</div>
                        <div class="text-white font-semibold text-sm">{{ $item['label'] }}</div>
                        <div class="text-white/40 text-xs mt-0.5">{{ $item['sub'] }}</div>
                    </div>
                @endforeach
            </div>
        </div>
    </main>

    <footer class="border-t border-white/10 px-8 py-5 text-center text-xs text-white/30">
        &copy; {{ date('Y') }} AcademiaCraft School of Excellence. All rights reserved.
    </footer>

</body>
</html>
