<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Result — AcademiaCraft</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&family=Playfair+Display:wght@600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-ink text-white font-sans antialiased min-h-screen flex flex-col">

    {{-- Header --}}
    <header class="border-b border-white/10 px-8 py-5">
        <div class="max-w-6xl mx-auto flex items-center justify-between">
            <a href="/" class="flex items-center gap-3">
                <div class="w-8 h-8 bg-gold rounded-lg flex items-center justify-center font-bold text-ink text-xs">AC</div>
                <span class="font-serif text-white font-semibold">AcademiaCraft</span>
            </a>
            <a href="{{ route('verify.index') }}" class="text-sm text-white/50 hover:text-white transition-colors">← Verify Another</a>
        </div>
    </header>

    <main class="flex-1 flex items-center justify-center px-6 py-16">
        <div class="max-w-lg w-full text-center">

            @if ($certificate)
                {{-- ── VALID ── --}}
                <div class="w-20 h-20 rounded-full bg-sage/20 border-2 border-sage/50 flex items-center justify-center text-sage text-4xl mx-auto mb-6">
                    ✓
                </div>
                <h1 class="font-serif text-3xl font-bold text-white mb-2">Certificate Valid</h1>
                <p class="text-white/50 text-sm mb-10">This certificate has been verified as authentic.</p>

                {{-- Certificate card --}}
                <div class="bg-white/[0.05] border border-white/10 rounded-3xl p-8 text-left space-y-4">

                    <div class="text-center pb-4 border-b border-white/10">
                        <div class="text-xs text-white/40 uppercase tracking-widest mb-1">Certificate of Completion</div>
                        <div class="font-serif text-2xl text-gold font-bold">{{ $certificate->enrollment->user->name }}</div>
                    </div>

                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <div class="text-white/40 text-xs uppercase tracking-wide mb-1">Programme</div>
                            <div class="text-white font-medium">{{ $certificate->enrollment->course->title }}</div>
                        </div>
                        <div>
                            <div class="text-white/40 text-xs uppercase tracking-wide mb-1">Type</div>
                            <div class="text-white font-medium capitalize">{{ $certificate->enrollment->course->type }}</div>
                        </div>
                        <div>
                            <div class="text-white/40 text-xs uppercase tracking-wide mb-1">Certificate No.</div>
                            <div class="font-mono text-white/80 text-xs">{{ $certificate->certificate_number }}</div>
                        </div>
                        <div>
                            <div class="text-white/40 text-xs uppercase tracking-wide mb-1">Date Issued</div>
                            <div class="text-white font-medium">{{ $certificate->issued_at->format('d F Y') }}</div>
                        </div>
                    </div>

                    <div class="pt-4 border-t border-white/10">
                        <div class="text-white/40 text-xs uppercase tracking-wide mb-1">Verification Code</div>
                        <div class="font-mono text-[11px] text-white/30 break-all">{{ $code }}</div>
                    </div>
                </div>

                <div class="mt-6 inline-flex items-center gap-2 px-4 py-2 rounded-full bg-sage/10 border border-sage/20 text-sage text-xs font-medium">
                    ● Verified by AcademiaCraft School of Excellence
                </div>

            @else
                {{-- ── INVALID ── --}}
                <div class="w-20 h-20 rounded-full bg-rust/20 border-2 border-rust/50 flex items-center justify-center text-rust text-4xl mx-auto mb-6">
                    ✕
                </div>
                <h1 class="font-serif text-3xl font-bold text-white mb-2">Not Found</h1>
                <p class="text-white/50 text-sm mb-8">
                    No certificate matches the code you entered. Please check the code and try again.
                </p>

                <div class="bg-white/[0.04] border border-white/10 rounded-2xl p-5 mb-8 text-left">
                    <div class="text-white/40 text-xs uppercase tracking-wide mb-2">Searched for</div>
                    <div class="font-mono text-sm text-white/60 break-all">{{ $code }}</div>
                </div>

                <div class="space-y-3">
                    <a href="{{ route('verify.index') }}"
                       class="block w-full py-3.5 bg-gold text-ink font-semibold text-sm rounded-2xl hover:bg-gold-light transition-colors">
                        Try Again
                    </a>
                    <p class="text-white/30 text-xs">
                        If you believe this is an error, please contact <span class="text-white/50">admin@academiacraft.ac.ke</span>
                    </p>
                </div>
            @endif

        </div>
    </main>

    <footer class="border-t border-white/10 px-8 py-5 text-center text-xs text-white/30">
        &copy; {{ date('Y') }} AcademiaCraft School of Excellence. All rights reserved.
    </footer>

</body>
</html>
