@extends('layouts.app')

@section('title', 'AcademiaCraft — School of Excellence')

@section('content')

{{-- HERO SECTION --}}
<section class="min-h-screen grid grid-cols-2">

    {{-- Left Side --}}
    <div class="flex flex-col justify-center px-16 py-24">
        <div class="inline-flex items-center gap-2 bg-gold text-ink text-xs font-bold uppercase tracking-widest px-4 py-1.5 rounded-full w-fit mb-8">
            ✦ Kenya's Premier Skills Institute
        </div>

        <h1 class="font-serif text-6xl font-black leading-none tracking-tight mb-6">
            Shape Your<br>
            <em class="text-gold">Future</em> with<br>
            Excellence.
        </h1>

        <p class="text-ink/60 text-lg leading-relaxed max-w-md mb-10">
            Earn nationally recognized Diploma and Artisan certifications.
            Enroll online, learn at your pace, and receive your certificate upon completion.
        </p>

        <div class="flex items-center gap-4 mb-16">
            <a href="/courses" class="btn-primary">Explore Courses →</a>
            <a href="/register" class="btn-outline">Get Started</a>
        </div>

        {{-- Stats --}}
        <div class="flex gap-10">
            <div>
                <div class="font-serif text-4xl font-black">2,400+</div>
                <div class="text-xs uppercase tracking-widest text-ink/40 font-medium mt-1">Graduates</div>
            </div>
            <div class="w-px bg-black/10"></div>
            <div>
                <div class="font-serif text-4xl font-black">18</div>
                <div class="text-xs uppercase tracking-widest text-ink/40 font-medium mt-1">Programmes</div>
            </div>
            <div class="w-px bg-black/10"></div>
            <div>
                <div class="font-serif text-4xl font-black">97%</div>
                <div class="text-xs uppercase tracking-widest text-ink/40 font-medium mt-1">Pass Rate</div>
            </div>
        </div>
    </div>

    {{-- Right Side --}}
    <div class="bg-ink relative overflow-hidden grid grid-rows-2">
        <div class="bg-gradient-to-br from-green-950 to-green-800 flex items-end p-10 relative">
            <div class="absolute top-4 left-6 text-xs tracking-widest uppercase text-white/20">01 / Diploma</div>
            <div class="bg-white/10 backdrop-blur border border-white/15 rounded-2xl p-6 text-white relative z-10">
                <div class="text-xs uppercase tracking-widest text-white/40 mb-2">Featured Programme</div>
                <div class="font-serif text-xl font-bold mb-3">Diploma in Business Administration</div>
                <div class="flex items-center gap-3">
                    <span class="badge-diploma">Diploma</span>
                    <span class="text-white/50 text-xs">24 Weeks · Online</span>
                </div>
            </div>
        </div>
        <div class="bg-gradient-to-br from-amber-950 to-amber-800 flex items-start p-10 relative">
            <div class="absolute bottom-4 right-6 text-xs tracking-widest uppercase text-white/20">02 / Artisan</div>
            <div class="bg-white/10 backdrop-blur border border-white/15 rounded-2xl p-6 text-white relative z-10">
                <div class="text-xs uppercase tracking-widest text-white/40 mb-2">Trending Craft</div>
                <div class="font-serif text-xl font-bold mb-3">Artisan Certificate in Welding & Fabrication</div>
                <div class="flex items-center gap-3">
                    <span class="bg-red-900/60 text-red-200 text-xs font-bold uppercase tracking-widest px-3 py-1 rounded-full">Artisan</span>
                    <span class="text-white/50 text-xs">12 Weeks · Hands-on</span>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- TICKER --}}
<div class="bg-ink overflow-hidden whitespace-nowrap py-3.5">
    <div class="inline-flex animate-ticker">
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Nationally Recognized Certificates</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Diploma Programmes</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Artisan Craft Courses</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Online Enrollment</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Digital Certificates</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Expert Instructors</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Nationally Recognized Certificates</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Diploma Programmes</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Artisan Craft Courses</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Online Enrollment</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Digital Certificates</span>
        <span class="inline-flex items-center gap-6 text-cream/70 text-xs font-bold uppercase tracking-widest pr-16"><span class="text-gold">✦</span> Expert Instructors</span>
    </div>
</div>

{{-- COURSES PREVIEW --}}
<section class="bg-white py-24">
    <div class="max-w-7xl mx-auto px-8">
        <div class="flex justify-between items-end mb-14">
            <div>
                <div class="section-label">✦ Our Programmes</div>
                <h2 class="font-serif text-5xl font-black leading-tight">Courses That<br>Open Doors</h2>
            </div>
            <a href="/courses" class="btn-dark">View All Courses →</a>
        </div>

        <div class="grid grid-cols-3 gap-8">
            @foreach($courses as $course)
            <div class="card overflow-hidden group cursor-pointer">
                <div class="h-48 flex items-end p-6
                    {{ $course->type === 'diploma' ? 'bg-gradient-to-br from-green-950 to-green-700' : 'bg-gradient-to-br from-amber-950 to-amber-700' }}">
                    <div class="w-12 h-12 rounded-xl bg-white/15 flex items-center justify-center text-2xl">
                        {{ $course->type === 'diploma' ? '📊' : '🔧' }}
                    </div>
                </div>
                <div class="p-6">
                    <span class="{{ $course->type === 'diploma' ? 'badge-diploma' : 'badge-artisan' }} mb-3 inline-block">
                        {{ ucfirst($course->type) }}
                    </span>
                    <h3 class="font-serif text-xl font-bold mb-2">{{ $course->title }}</h3>
                    <p class="text-ink/50 text-sm leading-relaxed mb-6">{{ $course->description }}</p>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-100">
                        <div>
                            <div class="font-semibold text-sm">{{ $course->duration_weeks }} Weeks</div>
                            <div class="text-xs text-ink/40 uppercase tracking-wide">Duration</div>
                        </div>
                        <div>
                            <div class="font-semibold text-sm">KES {{ number_format($course->fee) }}</div>
                            <div class="text-xs text-ink/40 uppercase tracking-wide">Fee</div>
                        </div>
                        <a href="/courses/{{ $course->slug }}"
                           class="w-9 h-9 bg-ink text-cream rounded-full flex items-center justify-center hover:bg-gold hover:text-ink transition-all duration-200 text-sm">
                            →
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

{{-- HOW IT WORKS --}}
<section class="bg-cream py-24 relative overflow-hidden">
    <div class="max-w-7xl mx-auto px-8">
        <div class="section-label">Simple Process</div>
        <h2 class="font-serif text-5xl font-black leading-tight tracking-tight">From Signup to<br>Certificate in 4 Steps</h2>

        <div class="grid grid-cols-2 gap-24 items-center mt-16">

            {{-- Steps list --}}
            <div>
                <div class="group grid grid-cols-[52px_1fr] gap-6 items-start pb-8 border-b border-ink/10 cursor-pointer">
                    <div class="w-[52px] h-[52px] rounded-full bg-ink text-cream font-serif font-black text-lg flex items-center justify-center shrink-0 group-hover:bg-gold group-hover:text-ink transition-all duration-200">01</div>
                    <div>
                        <div class="font-serif text-xl font-bold tracking-tight mb-1.5">Create Your Account</div>
                        <p class="text-sm text-ink/55 leading-relaxed">Register with your name, email, and phone number. Verify your email and complete your student profile in minutes.</p>
                    </div>
                </div>
                <div class="group grid grid-cols-[52px_1fr] gap-6 items-start py-8 border-b border-ink/10 cursor-pointer">
                    <div class="w-[52px] h-[52px] rounded-full bg-ink text-cream font-serif font-black text-lg flex items-center justify-center shrink-0 group-hover:bg-gold group-hover:text-ink transition-all duration-200">02</div>
                    <div>
                        <div class="font-serif text-xl font-bold tracking-tight mb-1.5">Choose Your Programme</div>
                        <p class="text-sm text-ink/55 leading-relaxed">Browse our Diploma and Artisan courses. Select the programme that matches your goals and career ambitions.</p>
                    </div>
                </div>
                <div class="group grid grid-cols-[52px_1fr] gap-6 items-start py-8 border-b border-ink/10 cursor-pointer">
                    <div class="w-[52px] h-[52px] rounded-full bg-ink text-cream font-serif font-black text-lg flex items-center justify-center shrink-0 group-hover:bg-gold group-hover:text-ink transition-all duration-200">03</div>
                    <div>
                        <div class="font-serif text-xl font-bold tracking-tight mb-1.5">Enroll & Learn</div>
                        <p class="text-sm text-ink/55 leading-relaxed">Pay your enrollment fee, gain instant access to course modules, and learn at your own pace with expert guidance.</p>
                    </div>
                </div>
                <div class="group grid grid-cols-[52px_1fr] gap-6 items-start pt-8 cursor-pointer">
                    <div class="w-[52px] h-[52px] rounded-full bg-ink text-cream font-serif font-black text-lg flex items-center justify-center shrink-0 group-hover:bg-gold group-hover:text-ink transition-all duration-200">04</div>
                    <div>
                        <div class="font-serif text-xl font-bold tracking-tight mb-1.5">Receive Your Certificate</div>
                        <p class="text-sm text-ink/55 leading-relaxed">Complete all modules, pass assessments, and receive your digital certificate instantly — downloadable and shareable.</p>
                    </div>
                </div>
            </div>

            {{-- Certificate preview --}}
            <div class="relative">
                <span class="absolute -top-5 right-8 bg-gold text-ink text-xs font-bold uppercase tracking-widest px-4 py-1.5 rounded-full z-10">✦ Instant Download</span>
                <div class="bg-ink rounded-3xl p-12 text-white relative overflow-hidden shadow-[0_40px_80px_rgba(0,0,0,0.25)]">
                    <div class="absolute top-0 left-0 right-0 h-[5px] bg-gradient-to-r from-gold via-rust to-gold"></div>
                    <div class="flex items-center justify-between mb-10">
                        <div class="w-14 h-14 rounded-full border-2 border-gold flex items-center justify-center text-gold font-serif font-bold text-xs text-center leading-tight">ACAD<br>CRAFT</div>
                        <div class="text-xs font-semibold uppercase tracking-widest text-gold">Certificate of Completion</div>
                    </div>
                    <div>
                        <div class="text-xs uppercase tracking-widest text-white/45 mb-2">This certifies that</div>
                        <div class="font-serif text-4xl font-black tracking-tight text-white mb-1.5">Amina Wanjiku</div>
                        <div class="text-sm text-white/55 mb-8">has successfully completed the <span class="text-gold font-semibold">Diploma in Business Administration</span></div>
                        <div class="h-px bg-white/10 mb-6"></div>
                        <div class="flex justify-between items-end">
                            <div>
                                <div class="w-24 h-px bg-white/25 mb-1.5"></div>
                                <div class="text-xs uppercase tracking-widest text-white/35">Principal, AcademiaCraft</div>
                            </div>
                            <div class="text-xs text-white/30 tracking-wide">CERT-2026-00247</div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

{{-- TESTIMONIALS --}}
<section class="bg-ink py-24 relative overflow-hidden">
    <div class="max-w-7xl mx-auto px-8">
        <div class="section-label">Student Stories</div>
        <h2 class="font-serif text-5xl font-black leading-tight tracking-tight text-cream">What Our Graduates Say</h2>

        <div class="grid grid-cols-3 gap-6 mt-16">
            <div class="bg-white/5 border border-white/[0.08] rounded-2xl p-8 hover:bg-white/[0.08] hover:border-gold/30 transition-all duration-300">
                <div class="text-gold text-sm tracking-widest mb-5">★★★★★</div>
                <p class="text-sm text-cream/70 leading-relaxed mb-7">"The Diploma in IT changed my career completely. The course material was practical and the certificate opened doors I never expected. I'm now employed at a tech firm in Nairobi."</p>
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-gold to-rust flex items-center justify-center font-serif font-bold text-sm text-ink shrink-0">JM</div>
                    <div>
                        <div class="font-semibold text-sm text-cream">James Mwangi</div>
                        <div class="text-xs text-cream/40 mt-0.5">Diploma in Information Technology</div>
                    </div>
                </div>
            </div>

            <div class="bg-white/5 border border-white/[0.08] rounded-2xl p-8 hover:bg-white/[0.08] hover:border-gold/30 transition-all duration-300">
                <div class="text-gold text-sm tracking-widest mb-5">★★★★★</div>
                <p class="text-sm text-cream/70 leading-relaxed mb-7">"I completed the Welding Artisan course in 12 weeks. The training was hands-on and thorough. I now run my own fabrication workshop and have more work than I can handle."</p>
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-gold to-rust flex items-center justify-center font-serif font-bold text-sm text-ink shrink-0">PK</div>
                    <div>
                        <div class="font-semibold text-sm text-cream">Peter Kamau</div>
                        <div class="text-xs text-cream/40 mt-0.5">Artisan Certificate — Welding</div>
                    </div>
                </div>
            </div>

            <div class="bg-white/5 border border-white/[0.08] rounded-2xl p-8 hover:bg-white/[0.08] hover:border-gold/30 transition-all duration-300">
                <div class="text-gold text-sm tracking-widest mb-5">★★★★★</div>
                <p class="text-sm text-cream/70 leading-relaxed mb-7">"Getting my certificate online on the same day I finished was incredible. I could share it with employers immediately. AcademiaCraft makes the whole process so smooth and professional."</p>
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-gold to-rust flex items-center justify-center font-serif font-bold text-sm text-ink shrink-0">FO</div>
                    <div>
                        <div class="font-semibold text-sm text-cream">Faith Otieno</div>
                        <div class="text-xs text-cream/40 mt-0.5">Diploma in Business Admin</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- CTA --}}
<section class="bg-cream py-28 text-center relative overflow-hidden">
    <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] rounded-full border border-gold/[0.12] pointer-events-none"></div>
    <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[400px] h-[400px] rounded-full border border-gold/[0.08] pointer-events-none"></div>
    <div class="relative z-10 max-w-2xl mx-auto px-8">
        <div class="section-label justify-center">Ready to Begin?</div>
        <h2 class="font-serif text-5xl font-black leading-tight tracking-tight mb-5">Start Your Journey <em class="text-gold italic">Today</em></h2>
        <p class="text-ink/55 text-lg leading-relaxed mb-10">Join over 2,400 graduates who have transformed their lives with AcademiaCraft programmes. Enroll online in minutes.</p>
        <div class="flex gap-4 justify-center">
            <a href="/courses" class="bg-gold text-ink font-bold py-3.5 px-8 rounded-xl hover:bg-gold-light transition-all duration-200 inline-flex items-center gap-2">Browse All Courses →</a>
            <a href="#" class="border-2 border-ink text-ink font-bold py-3.5 px-8 rounded-xl hover:bg-ink hover:text-cream transition-all duration-200 inline-flex items-center gap-2">Contact Admissions</a>
        </div>
    </div>
</section>

@endsection
