<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EnrollmentController;
use App\Http\Controllers\CertificateController;
use App\Http\Controllers\VerificationController;
use App\Http\Controllers\Admin\CourseController as AdminCourseController;
use App\Http\Controllers\Admin\CourseUnitController as AdminCourseUnitController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\EnrollmentController as AdminEnrollmentController;
use App\Models\Course;

// ── Public routes (anyone can visit) ──
Route::get('/', function () {
    $courses = Course::where('is_active', true)->take(3)->get();
    return view('welcome', compact('courses'));
});
Route::get('/courses', [CourseController::class, 'index']);
Route::get('/courses/{course:slug}', [CourseController::class, 'show']);

// ── Certificate verification (public) ──
Route::get('/verify', [VerificationController::class, 'show'])->name('verify.index');
Route::post('/verify', [VerificationController::class, 'check'])->name('verify.check');
Route::get('/verify/{code}', [VerificationController::class, 'result'])->name('verify.result');

// ── Student routes (must be logged in) ──
Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])
         ->name('dashboard');

    Route::post('/enroll/{course}', [EnrollmentController::class, 'store'])
         ->name('enroll');

    Route::get('/certificates/{id}/download', [CertificateController::class, 'download'])
         ->name('certificate.download');
});

// ── Admin routes (must be admin) ──
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');

    Route::resource('courses', AdminCourseController::class);

    // Course units (semesters)
    Route::post('/courses/{course}/units', [AdminCourseUnitController::class, 'store'])
         ->name('courses.units.store');
    Route::delete('/courses/{course}/units/{unit}', [AdminCourseUnitController::class, 'destroy'])
         ->name('courses.units.destroy');

    Route::get('/enrollments', [AdminEnrollmentController::class, 'index'])
         ->name('enrollments.index');
    Route::post('/enrollments/{enrollment}/complete', [AdminEnrollmentController::class, 'complete'])
         ->name('enrollments.complete');
});

// Breeze auth routes (login, register, etc.)
require __DIR__.'/auth.php';
