import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                     sans: ['DM Sans', ...defaultTheme.fontFamily.sans],
                serif: ['Playfair Display', ...defaultTheme.fontFamily.serif],
            },
             colors: {
                cream: '#F5F0E8',
                gold: {
                    DEFAULT: '#C8972A',
                    light: '#E8B84B',
                },
                ink: '#0D0D0D',
                rust: '#B84B2A',
                sage: '#4A6741',
            },
        },
    },

    plugins: [forms],
};
